/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiDisjunctionType
extends PsiType.Stub {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types);
        this.myLubCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(() -> {
            PsiType lub = this.myTypes.get(0);
            for (int i2 = 1; i2 < this.myTypes.size(); ++i2) {
                if ((lub = GenericsUtil.getLeastUpperBound(lub, this.myTypes.get(i2), this.myManager)) != null) continue;
                lub = PsiType.getJavaLangObject(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                break;
            }
            return CachedValueProvider.Result.create(lub, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }, false);
    }

    @NotNull
    public static PsiType createDisjunction(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        assert (!types.isEmpty());
        return types.size() == 1 ? types.get(0) : new PsiDisjunctionType(types, psiManager);
    }

    @NotNull
    public PsiType getLeastUpperBound() {
        return this.myLubCache.getValue();
    }

    @NotNull
    public List<PsiType> getDisjunctions() {
        return this.myTypes;
    }

    @NotNull
    public PsiDisjunctionType newDisjunctionType(List<PsiType> types) {
        return new PsiDisjunctionType(types, this.myManager);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        return StringUtil.join(this.myTypes, psiType -> psiType.getPresentableText(annotated), (String)" | ");
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return StringUtil.join(this.myTypes, psiType -> psiType.getCanonicalText(annotated), (String)" | ");
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return StringUtil.join(this.myTypes, psiType -> psiType.getInternalCanonicalText(), (String)" | ");
    }

    @Override
    public boolean isValid() {
        for (PsiType type : this.myTypes) {
            if (type.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text) {
        return Comparing.equal((String)text, (String)this.getCanonicalText());
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            return ((PsiIntersectionType)lub).getConjuncts();
        }
        return new PsiType[]{lub};
    }

    public int hashCode() {
        return this.myTypes.get(0).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDisjunctionType that = (PsiDisjunctionType)o;
        if (that.myTypes.size() != this.myTypes.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myTypes.size(); ++i2) {
            if (this.myTypes.get(i2).equals(that.myTypes.get(i2))) continue;
            return false;
        }
        return true;
    }
}

