/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiIntersectionType
extends PsiType.Stub {
    private final PsiType[] myConjuncts;

    private PsiIntersectionType(@NotNull PsiType[] conjuncts) {
        super(TypeAnnotationProvider.EMPTY);
        this.myConjuncts = conjuncts;
    }

    @NotNull
    public static PsiType createIntersection(@NotNull List<PsiType> conjuncts) {
        return PsiIntersectionType.createIntersection(conjuncts.toArray(PsiIntersectionType.createArray(conjuncts.size())));
    }

    @NotNull
    public static PsiType createIntersection(PsiType ... conjuncts) {
        return PsiIntersectionType.createIntersection(true, conjuncts);
    }

    @NotNull
    public static PsiType createIntersection(boolean flatten, PsiType ... conjuncts) {
        assert (conjuncts.length > 0);
        if (flatten) {
            conjuncts = PsiIntersectionType.flattenAndRemoveDuplicates(conjuncts);
        }
        if (conjuncts.length == 1) {
            return conjuncts[0];
        }
        return new PsiIntersectionType(conjuncts);
    }

    private static PsiType[] flattenAndRemoveDuplicates(PsiType[] conjuncts) {
        try {
            Set flattenConjuncts = (Set)PsiCapturedWildcardType.guard.doPreventingRecursion((Object)conjuncts, true, () -> PsiIntersectionType.flatten(conjuncts, ContainerUtil.newLinkedHashSet()));
            if (flattenConjuncts == null) {
                return conjuncts;
            }
            return flattenConjuncts.toArray(PsiIntersectionType.createArray(flattenConjuncts.size()));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(Arrays.toString(conjuncts), e);
        }
    }

    public static Set<PsiType> flatten(PsiType[] conjuncts, Set<PsiType> types) {
        for (PsiType conjunct : conjuncts) {
            if (conjunct instanceof PsiIntersectionType) {
                PsiIntersectionType type = (PsiIntersectionType)conjunct;
                PsiIntersectionType.flatten(type.getConjuncts(), types);
                continue;
            }
            types.add(conjunct);
        }
        if (types.size() > 1) {
            PsiType[] array = types.toArray(PsiIntersectionType.createArray(types.size()));
            Iterator<PsiType> iterator = types.iterator();
            block1: while (iterator.hasNext()) {
                PsiType type = iterator.next();
                for (PsiType existing : array) {
                    boolean allowUncheckedConversion;
                    if (type == existing) continue;
                    boolean bl = allowUncheckedConversion = type instanceof PsiClassType && ((PsiClassType)type).isRaw();
                    if (!TypeConversionUtil.isAssignable(type, existing, allowUncheckedConversion)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            if (types.isEmpty()) {
                types.add(array[0]);
            }
        }
        return types;
    }

    @NotNull
    public PsiType[] getConjuncts() {
        return this.myConjuncts;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        return StringUtil.join((Object[])this.myConjuncts, psiType -> psiType.getPresentableText(annotated), (String)" & ");
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.myConjuncts[0].getCanonicalText(annotated);
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return StringUtil.join((Object[])this.myConjuncts, psiType -> psiType.getInternalCanonicalText(), (String)" & ");
    }

    @Override
    public boolean isValid() {
        for (PsiType conjunct : this.myConjuncts) {
            if (conjunct.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitIntersectionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myConjuncts[0].getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        return this.myConjuncts;
    }

    @NotNull
    public PsiType getRepresentative() {
        return this.myConjuncts[0];
    }

    public boolean equals(Object obj) {
        PsiType[] second;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiIntersectionType)) {
            return false;
        }
        PsiType[] first = this.getConjuncts();
        if (first.length != (second = ((PsiIntersectionType)obj).getConjuncts()).length) {
            return false;
        }
        for (int i2 = 0; i2 < first.length; ++i2) {
            if (first[i2].equals(second[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myConjuncts[0].hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PsiIntersectionType: ");
        for (int i2 = 0; i2 < this.myConjuncts.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(this.myConjuncts[i2].getPresentableText());
        }
        return sb.toString();
    }

    public String getConflictingConjunctsMessage() {
        PsiType[] conjuncts = this.getConjuncts();
        for (int i2 = 0; i2 < conjuncts.length; ++i2) {
            PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i2]);
            if (conjunct == null || conjunct.isInterface()) continue;
            for (int i1 = i2 + 1; i1 < conjuncts.length; ++i1) {
                PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i1]);
                if (oppositeConjunct == null || oppositeConjunct.isInterface() || conjunct.isInheritor(oppositeConjunct, true) || oppositeConjunct.isInheritor(conjunct, true)) continue;
                return conjuncts[i2].getPresentableText() + " and " + conjuncts[i1].getPresentableText();
            }
        }
        return null;
    }
}

