/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiNameHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");

    public static PsiNameHelper getInstance(Project project) {
        return ServiceManager.getService(project, PsiNameHelper.class);
    }

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, @NotNull LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    @NotNull
    public static String getShortClassName(@NotNull String referenceText) {
        String sub;
        int i2;
        int lessPos = referenceText.length();
        int bracesBalance = 0;
        block5: for (i2 = referenceText.length() - 1; i2 >= 0; --i2) {
            char ch = referenceText.charAt(i2);
            switch (ch) {
                case ')': 
                case '>': {
                    ++bracesBalance;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --bracesBalance;
                    lessPos = i2;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (bracesBalance > 0) continue block5;
                    break block5;
                }
                default: {
                    if (!Character.isWhitespace(ch) || bracesBalance > 0) continue block5;
                    for (int j = i2 + 1; j < lessPos; ++j) {
                        if (!Character.isWhitespace(referenceText.charAt(j))) break block5;
                    }
                    lessPos = i2;
                }
            }
        }
        return (sub = referenceText.substring(i2 + 1, lessPos).trim()).length() == referenceText.length() ? sub : new String(sub);
    }

    @NotNull
    public static String getPresentableText(@NotNull PsiJavaCodeReferenceElement ref) {
        String name = ref.getReferenceName();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        return PsiNameHelper.getPresentableText(name, (PsiAnnotation[])ObjectUtils.notNull((Object)annotations, (Object)PsiAnnotation.EMPTY_ARRAY), ref.getTypeParameters());
    }

    @NotNull
    public static String getPresentableText(@Nullable String refName, @NotNull PsiAnnotation[] annotations, @NotNull PsiType[] types) {
        if (types.length == 0 && annotations.length == 0) {
            return refName != null ? refName : "";
        }
        StringBuilder buffer = new StringBuilder();
        PsiNameHelper.appendAnnotations(buffer, annotations, false);
        buffer.append(refName);
        PsiNameHelper.appendTypeArgs(buffer, types, false, true);
        return buffer.toString();
    }

    @NotNull
    public static String getQualifiedClassName(@NotNull String referenceText, boolean removeWhitespace) {
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            return referenceText;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count = 0;
        block4: for (int i2 = 0; i2 < chars.length; ++i2) {
            char aChar = chars[i2];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i2 - gtPos));
                    continue block4;
                }
                case '>': {
                    --count;
                    gtPos = i2 + 1;
                }
            }
        }
        if (count == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        return buffer.toString();
    }

    private static String removeWhitespace(@NotNull String referenceText) {
        boolean needsChange = false;
        for (int i2 = 0; i2 < referenceText.length(); ++i2) {
            char c = referenceText.charAt(i2);
            if (c != '/' && !Character.isWhitespace(c)) continue;
            needsChange = true;
            break;
        }
        if (!needsChange) {
            return referenceText;
        }
        return WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
    }

    @NotNull
    public static String[] getClassParametersText(@NotNull String referenceText) {
        if (referenceText.indexOf(60) < 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        char[] chars = referenceText.toCharArray();
        int afterLastDotIndex = 0;
        int level = 0;
        block15: for (int i2 = 0; i2 < chars.length; ++i2) {
            char aChar = chars[i2];
            switch (aChar) {
                case '<': {
                    ++level;
                    continue block15;
                }
                case '.': {
                    if (level != 0) continue block15;
                    afterLastDotIndex = i2 + 1;
                    continue block15;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int dim = 0;
        block16: for (int i3 = afterLastDotIndex; i3 < chars.length; ++i3) {
            char aChar = chars[i3];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case ',': {
                    if (level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0 || dim == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[dim];
        dim = 0;
        int ltPos = 0;
        block17: for (int i4 = afterLastDotIndex; i4 < chars.length; ++i4) {
            char aChar = chars[i4];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block17;
                    ltPos = i4;
                    continue block17;
                }
                case ',': {
                    if (level != 1) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i4 - ltPos - 1);
                    ltPos = i4;
                    continue block17;
                }
                case '>': {
                    if (--level != 0) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i4 - ltPos - 1);
                }
            }
        }
        return result;
    }

    public static boolean isSubpackageOf(@NotNull String subpackageName, @NotNull String packageName) {
        return subpackageName.equals(packageName) || subpackageName.startsWith(packageName) && subpackageName.charAt(packageName.length()) == '.';
    }

    public static void appendTypeArgs(@NotNull StringBuilder sb, @NotNull PsiType[] types, boolean canonical, boolean annotated) {
        if (types.length == 0) {
            return;
        }
        sb.append('<');
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (i2 > 0) {
                sb.append(canonical ? "," : ", ");
            }
            PsiType type = types[i2];
            if (canonical) {
                sb.append(type.getCanonicalText(annotated));
                continue;
            }
            sb.append(type.getPresentableText());
        }
        sb.append('>');
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, @NotNull PsiAnnotation[] annotations, boolean canonical) {
        return PsiNameHelper.appendAnnotations(sb, Arrays.asList(annotations), canonical);
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, @NotNull List<PsiAnnotation> annotations, boolean canonical) {
        boolean updated = false;
        for (PsiAnnotation annotation : annotations) {
            if (canonical) {
                String name = annotation.getQualifiedName();
                if (name == null) continue;
                sb.append('@').append(name).append(annotation.getParameterList().getText()).append(' ');
                updated = true;
                continue;
            }
            PsiJavaCodeReferenceElement refElement = annotation.getNameReferenceElement();
            if (refElement == null) continue;
            sb.append('@').append(refElement.getText()).append(' ');
            updated = true;
        }
        return updated;
    }
}

