/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReferenceProviderType {
    @NonNls
    public static final String EP_NAME = "com.intellij.referenceProviderType";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.ReferenceProviderType");
    private static final KeyedExtensionCollector<PsiReferenceProvider, ReferenceProviderType> COLLECTOR = new KeyedExtensionCollector<PsiReferenceProvider, ReferenceProviderType>("com.intellij.referenceProviderType"){

        @Override
        @NotNull
        protected String keyToString(@NotNull ReferenceProviderType key) {
            return key.myId;
        }
    };
    private final String myId;

    public ReferenceProviderType(@NonNls @NotNull String id) {
        this.myId = id;
    }

    @NotNull
    public PsiReferenceProvider getProvider() {
        List<PsiReferenceProvider> list = COLLECTOR.forKey(this);
        LOG.assertTrue(!list.isEmpty(), (Object)this.myId);
        return list.size() == 1 ? list.get(0) : new CompositePsiReferenceProvider(list);
    }

    public String toString() {
        return this.myId;
    }

    private static class CompositePsiReferenceProvider
    extends PsiReferenceProvider {
        private final List<PsiReferenceProvider> children;

        private CompositePsiReferenceProvider(@NotNull List<PsiReferenceProvider> children) {
            this.children = children;
        }

        @Override
        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiReferenceProvider child : this.children) {
                ContainerUtil.addAllNotNull((Collection)result, (Object[])child.getReferencesByElement(element, context));
            }
            return result.toArray(new PsiReference[result.size()]);
        }

        @Override
        public boolean acceptsTarget(@NotNull PsiElement target) {
            for (PsiReferenceProvider child : this.children) {
                if (!child.acceptsTarget(target)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptsHints(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
            for (PsiReferenceProvider child : this.children) {
                if (!child.acceptsHints(element, hints)) continue;
                return true;
            }
            return false;
        }
    }
}

