/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.values;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ValuesExtractionResultImpl
implements ValuesExtractionResult {
    @NotNull
    protected final List<Value> myValues;

    public ValuesExtractionResultImpl(@NotNull List<Value> values) {
        this.myValues = values;
    }

    @Override
    @NotNull
    public List<Value> getValues() {
        return this.myValues;
    }

    @Override
    public void applySelected() {
        for (Value value : this.myValues) {
            if (value.state != Value.STATE.SELECTED) continue;
            value.write(false);
        }
    }

    @Override
    public void applyConditioned(Condition<Value> c, Map<Value, Object> backup) {
        for (Value value : this.myValues) {
            if (c.value((Object)value)) {
                value.write(false);
                continue;
            }
            value.value = backup.get(value);
            value.write(false);
        }
    }

    @Override
    @Contract(value="false -> null")
    public ValuesExtractionResult apply(boolean retPrevValue) {
        if (retPrevValue) {
            ArrayList<Value> orig = new ArrayList<Value>();
            for (Value value : this.myValues) {
                Value old = value.write(true);
                if (old == null) continue;
                orig.add(old);
            }
            return new Gens(orig);
        }
        for (Value value : this.myValues) {
            value.write(false);
        }
        return null;
    }
}

