/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSelectSettingPresentation
extends CodeStyleSettingPresentation {
    @NotNull
    protected int[] myValues;
    @NotNull
    protected String[] myValueUiNames;
    protected int myLowerBound;
    protected int myUpperBound;

    public CodeStyleSelectSettingPresentation(@NotNull String fieldName, @NotNull String uiName, @NotNull int[] values, @NotNull String[] valueUiNames) {
        super(fieldName, uiName);
        assert (values.length == valueUiNames.length);
        assert (values.length > 0);
        this.myValues = values;
        this.myValueUiNames = valueUiNames;
        this.myLowerBound = values[0];
        this.myUpperBound = values[0];
        for (int value : values) {
            this.myLowerBound = Math.min(value, this.myLowerBound);
            this.myUpperBound = Math.max(value, this.myUpperBound);
        }
    }

    @Override
    @NotNull
    public String getValueUiName(@NotNull Object value) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            for (int i2 = 0; i2 < this.myValues.length; ++i2) {
                if (this.myValues[i2] != intValue) continue;
                return this.myValueUiNames[i2];
            }
            return super.getValueUiName(value);
        }
        return super.getValueUiName(value);
    }

    public int getLowerBound() {
        return this.myLowerBound;
    }

    public int getUpperBound() {
        return this.myUpperBound;
    }

    @NotNull
    public int[] getValues() {
        return this.myValues;
    }

    @NotNull
    public String[] getOptions() {
        return this.myValueUiNames;
    }
}

