/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.annotations.NotNull;

public class PsiSearchRequest {
    @NotNull
    public final SearchScope searchScope;
    @NotNull
    public final String word;
    public final short searchContext;
    public final boolean caseSensitive;
    public final RequestResultProcessor processor;
    public final String containerName;

    public PsiSearchRequest(@NotNull SearchScope searchScope, @NotNull String word, short searchContext, boolean caseSensitive, @NotNull RequestResultProcessor processor) {
        this(searchScope, word, searchContext, caseSensitive, null, processor);
    }

    public PsiSearchRequest(@NotNull SearchScope searchScope, @NotNull String word, short searchContext, boolean caseSensitive, String containerName, @NotNull RequestResultProcessor processor) {
        this.containerName = containerName;
        if (word.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        this.searchScope = searchScope;
        this.word = word;
        this.searchContext = searchContext;
        this.caseSensitive = caseSensitive;
        this.processor = processor;
        if (searchScope instanceof GlobalSearchScope && ((GlobalSearchScope)searchScope).getProject() == null) {
            throw new AssertionError((Object)("Every search scope must be associated with a project: " + searchScope));
        }
    }

    public String toString() {
        return this.word + " -> " + this.processor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSearchRequest)) {
            return false;
        }
        PsiSearchRequest that = (PsiSearchRequest)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        if (this.searchContext != that.searchContext) {
            return false;
        }
        if (!this.processor.equals(that.processor)) {
            return false;
        }
        if (!this.searchScope.equals(that.searchScope)) {
            return false;
        }
        return this.word.equals(that.word);
    }

    public int hashCode() {
        int result = this.searchScope.hashCode();
        result = 31 * result + this.word.hashCode();
        result = 31 * result + this.searchContext;
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        result = 31 * result + this.processor.hashCode();
        return result;
    }
}

