/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SearchRequestCollector {
    private static final ExtensionPointName<ScopeOptimizer> CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.codeUsageScopeOptimizer");
    private final Object lock = new Object();
    private final List<PsiSearchRequest> myWordRequests = ContainerUtil.newArrayList();
    private final List<QuerySearchRequest> myQueryRequests = ContainerUtil.newArrayList();
    private final List<Processor<Processor<PsiReference>>> myCustomSearchActions = ContainerUtil.newArrayList();
    private final SearchSession mySession;

    public SearchRequestCollector(@NotNull SearchSession session) {
        this.mySession = session;
    }

    @NotNull
    public SearchSession getSearchSession() {
        return this.mySession;
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, boolean caseSensitive, @NotNull PsiElement searchTarget) {
        short searchContext = (short)(0xB | (searchTarget instanceof PsiFileSystemItem ? 4 : 0));
        this.searchWord(word, searchScope, searchContext, caseSensitive, searchTarget);
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull PsiElement searchTarget) {
        this.searchWord(word, searchScope, searchContext, caseSensitive, SearchRequestCollector.getContainerName(searchTarget), new SingleTargetRequestResultProcessor(searchTarget), searchTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, String containerName, @NotNull RequestResultProcessor processor, PsiElement searchTarget) {
        if (!SearchRequestCollector.makesSenseToSearch(word, searchScope)) {
            return;
        }
        Collection<PsiSearchRequest> requests = null;
        if (searchTarget != null && searchScope instanceof GlobalSearchScope && ((searchContext & 1) != 0 || searchContext == 255)) {
            for (ScopeOptimizer optimizer : (ScopeOptimizer[])CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME.getExtensions()) {
                GlobalSearchScope optimizedCodeUsageSearchScope = optimizer.getScopeToExclude(searchTarget);
                if (optimizedCodeUsageSearchScope == null) continue;
                short exceptCodeSearchContext = searchContext == 255 ? (short)30 : (short)(searchContext ^ 1);
                GlobalSearchScope searchCodeUsageEffectiveScope = ((GlobalSearchScope)searchScope).intersectWith(GlobalSearchScope.notScope(optimizedCodeUsageSearchScope));
                requests = ContainerUtil.list((Object[])new PsiSearchRequest[]{new PsiSearchRequest(searchCodeUsageEffectiveScope, word, 1, caseSensitive, containerName, processor), new PsiSearchRequest(searchScope, word, exceptCodeSearchContext, caseSensitive, containerName, processor)});
                break;
            }
        }
        if (requests == null) {
            requests = Collections.singleton(new PsiSearchRequest(searchScope, word, searchContext, caseSensitive, containerName, processor));
        }
        ScopeOptimizer[] scopeOptimizerArray = this.lock;
        synchronized (this.lock) {
            this.myWordRequests.addAll(requests);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return;
        }
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull PsiElement searchTarget, @NotNull RequestResultProcessor processor) {
        this.searchWord(word, searchScope, searchContext, caseSensitive, SearchRequestCollector.getContainerName(searchTarget), processor, searchTarget);
    }

    private static String getContainerName(@NotNull PsiElement target) {
        return (String)ReadAction.compute(() -> {
            PsiElement container = SearchRequestCollector.getContainer(target);
            return container instanceof PsiNamedElement ? ((PsiNamedElement)container).getName() : null;
        });
    }

    private static PsiElement getContainer(@NotNull PsiElement refElement) {
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return null;
    }

    @Deprecated
    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull RequestResultProcessor processor) {
        this.searchWord(word, searchScope, searchContext, caseSensitive, null, processor, null);
    }

    private static boolean makesSenseToSearch(@NotNull String word, @NotNull SearchScope searchScope) {
        if (searchScope instanceof LocalSearchScope && ((LocalSearchScope)searchScope).getScope().length == 0) {
            return false;
        }
        return searchScope != GlobalSearchScope.EMPTY_SCOPE && !StringUtil.isEmpty((String)word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchQuery(@NotNull QuerySearchRequest request) {
        assert (request.collector != this);
        assert (request.collector.getSearchSession() == this.mySession);
        Object object = this.lock;
        synchronized (object) {
            this.myQueryRequests.add(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchCustom(@NotNull Processor<Processor<PsiReference>> searchAction) {
        Object object = this.lock;
        synchronized (object) {
            this.myCustomSearchActions.add(searchAction);
        }
    }

    @NotNull
    public List<QuerySearchRequest> takeQueryRequests() {
        return this.takeRequests(this.myQueryRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <T> List<T> takeRequests(@NotNull List<T> list) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<T> requests = new ArrayList<T>(list);
            list.clear();
            return requests;
        }
    }

    @NotNull
    public List<PsiSearchRequest> takeSearchRequests() {
        return this.takeRequests(this.myWordRequests);
    }

    @NotNull
    public List<Processor<Processor<PsiReference>>> takeCustomSearchActions() {
        return this.takeRequests(this.myCustomSearchActions);
    }

    public String toString() {
        return this.myWordRequests.toString().replace(',', '\n') + ";" + this.myQueryRequests;
    }
}

