/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SearchRequestQuery
extends AbstractQuery<PsiReference> {
    private final Project myProject;
    private final SearchRequestCollector myRequests;

    public SearchRequestQuery(@NotNull Project project, @NotNull SearchRequestCollector requests) {
        this.myProject = project;
        this.myRequests = requests;
    }

    @Override
    @NotNull
    protected AsyncFuture<Boolean> processResultsAsync(@NotNull Processor<PsiReference> consumer) {
        return PsiSearchHelper.SERVICE.getInstance(this.myProject).processRequestsAsync(this.myRequests, consumer);
    }

    @Override
    protected boolean processResults(@NotNull Processor<PsiReference> consumer) {
        return PsiSearchHelper.SERVICE.getInstance(this.myProject).processRequests(this.myRequests, consumer);
    }

    public String toString() {
        return this.myRequests.toString();
    }
}

