/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.Colored;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Colored(color="ffffe4", darkVariant="494539")
public class NonProjectFilesScope
extends NamedScope {
    public static final String NAME = "Non-Project Files";

    public NonProjectFilesScope() {
        super(NAME, new AbstractPackageSet("NonProject"){

            @Override
            public boolean contains(VirtualFile file, NamedScopesHolder holder) {
                return this.contains(file, holder.getProject(), holder);
            }

            @Override
            public boolean contains(VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                if (file == null || file.getFileSystem() instanceof NonPhysicalFileSystem) {
                    return false;
                }
                if (!file.isInLocalFileSystem()) {
                    return true;
                }
                if (NonProjectFilesScope.isInsideProjectContent(project, file)) {
                    return false;
                }
                return !ProjectScope.getProjectScope(project).contains(file);
            }
        });
    }

    private static boolean isInsideProjectContent(@NotNull Project project, @NotNull VirtualFile file) {
        String projectBaseDir;
        if (!file.isInLocalFileSystem() && (projectBaseDir = project.getBasePath()) != null) {
            return FileUtil.isAncestor((String)projectBaseDir, (String)file.getPath(), (boolean)false);
        }
        return false;
    }

    @NotNull
    public static NamedScope[] removeFromList(@NotNull NamedScope[] scopes) {
        int nonProjectIdx = -1;
        int length = scopes.length;
        for (int i2 = 0; i2 < length; ++i2) {
            NamedScope scope = scopes[i2];
            if (!(scope instanceof NonProjectFilesScope)) continue;
            nonProjectIdx = i2;
            break;
        }
        if (nonProjectIdx > -1) {
            scopes = (NamedScope[])ArrayUtil.remove((Object[])scopes, (int)nonProjectIdx);
        }
        return scopes;
    }
}

