/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import org.jetbrains.annotations.NotNull;

public class NamedPackageSetReference
extends PackageSetBase {
    private final String myName;

    public NamedPackageSetReference(String name) {
        this.myName = StringUtil.trimStart((String)name, (String)"$");
    }

    @Override
    public boolean contains(VirtualFile file, NamedScopesHolder holder) {
        PackageSet packageSet;
        if (holder == null) {
            return false;
        }
        NamedScope scope = holder.getScope(this.myName);
        if (scope != null && (packageSet = scope.getValue()) != null) {
            return packageSet instanceof PackageSetBase ? ((PackageSetBase)packageSet).contains(file, holder) : packageSet.contains(NamedPackageSetReference.getPsiFile(file, holder.getProject()), holder);
        }
        return false;
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        return new NamedPackageSetReference(this.myName);
    }

    @Override
    @NotNull
    public String getText() {
        return "$" + this.myName;
    }

    @Override
    public int getNodePriority() {
        return 0;
    }
}

