/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class DefinitionsScopedSearch
extends ExtensibleQueryFactory<PsiElement, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME;
    public static final DefinitionsScopedSearch INSTANCE;

    public static Query<PsiElement> search(PsiElement definitionsOf) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf));
    }

    public static Query<PsiElement> search(PsiElement definitionsOf, SearchScope searchScope) {
        return DefinitionsScopedSearch.search(definitionsOf, searchScope, true);
    }

    public static Query<PsiElement> search(PsiElement definitionsOf, SearchScope searchScope, boolean checkDeep) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf, searchScope, checkDeep));
    }

    static {
        QueryExecutor[] OLD_EXECUTORS;
        EP_NAME = ExtensionPointName.create((String)"com.intellij.definitionsScopedSearch");
        INSTANCE = new DefinitionsScopedSearch();
        for (final QueryExecutor executor : OLD_EXECUTORS = (QueryExecutor[])DefinitionsSearch.EP_NAME.getExtensions()) {
            INSTANCE.registerExecutor(new QueryExecutor<PsiElement, SearchParameters>(){

                @Override
                public boolean execute(@NotNull SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
                    return executor.execute(queryParameters.getElement(), consumer);
                }
            });
        }
    }

    public static class SearchParameters {
        private final PsiElement myElement;
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(final @NotNull PsiElement element) {
            this(element, ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

                public SearchScope compute() {
                    return element.getUseScope();
                }
            }), true);
        }

        public SearchParameters(@NotNull PsiElement element, @NotNull SearchScope scope, boolean checkDeep) {
            this.myElement = element;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            return (SearchScope)ReadAction.compute(() -> {
                PsiFile file = this.myElement.getContainingFile();
                return this.myScope.intersectWith(PsiSearchHelper.SERVICE.getInstance(this.myElement.getProject()).getUseScope(file != null ? file : this.myElement));
            });
        }
    }
}

