/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;
import org.jetbrains.annotations.NotNull;

public abstract class IndexPatternSearch
extends QueryFactory<IndexPatternOccurrence, SearchParameters> {
    protected IndexPatternSearch() {
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        SearchParameters parameters = new SearchParameters(file, pattern);
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, pattern, new TextRange(startOffset, endOffset));
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, patternProvider, new TextRange(startOffset, endOffset));
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, patternProvider);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, pattern);
    }

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPattern var2);

    public static class SearchParameters {
        private final PsiFile myFile;
        private final IndexPattern myPattern;
        private final IndexPatternProvider myPatternProvider;
        private final TextRange myRange;

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
            this(file, pattern, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern, TextRange range) {
            this.myFile = file;
            this.myRange = range;
            this.myPatternProvider = null;
            this.myPattern = pattern;
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
            this(file, patternProvider, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, TextRange range) {
            this.myFile = file;
            this.myPatternProvider = patternProvider;
            this.myRange = range;
            this.myPattern = null;
        }

        @NotNull
        public PsiFile getFile() {
            return this.myFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }
    }

    private static class Holder {
        private static final IndexPatternSearch INDEX_PATTERN_SEARCH_INSTANCE = ServiceManager.getService(IndexPatternSearch.class);

        private Holder() {
        }
    }
}

