/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet(Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return false;
        }
    };
    public static final TokenSet ANY = new TokenSet(Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return true;
        }
    };
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
    }

    private boolean get(int index) {
        int wordIndex = (index >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index) != 0L;
    }

    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i2 = t.getIndex();
        return 0 <= i2 && i2 <= this.myMax && this.get(i2);
    }

    @NotNull
    public IElementType[] getTypes() {
        IElementType[] types = this.myTypes;
        if (types == null) {
            if (this.myWords.length == 0) {
                types = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list = new ArrayList<IElementType>();
                for (short i2 = (short)Math.max(1, this.myShift << 6); i2 <= this.myMax; i2 = (short)(i2 + 1)) {
                    IElementType type;
                    if (!this.get(i2) || (type = IElementType.find(i2)) == null) continue;
                    list.add(type);
                }
                types = list.toArray(new IElementType[list.size()]);
            }
            this.myTypes = types;
        }
        return types;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        if (types.length == 0) {
            return EMPTY;
        }
        short min = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type : types) {
            if (type == null) continue;
            short index = type.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass((Object)type);
            if (min > index) {
                min = index;
            }
            if (max >= index) continue;
            max = index;
        }
        short shift = (short)(min >> 6);
        TokenSet set = new TokenSet(shift, max);
        for (IElementType type : types) {
            int wordIndex;
            if (type == null) continue;
            short index = type.getIndex();
            int n = wordIndex = (index >> 6) - shift;
            set.myWords[n] = set.myWords[n] | 1L << index;
        }
        return set;
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets.length == 0) {
            return EMPTY;
        }
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i2 = 1; i2 < sets.length; ++i2) {
            if (shift > sets[i2].myShift) {
                shift = sets[i2].myShift;
            }
            if (max >= sets[i2].myMax) continue;
            max = sets[i2].myMax;
        }
        TokenSet newSet = new TokenSet(shift, max);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i3 = 0; i3 < set.myWords.length; ++i3) {
                int n = i3 + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i3];
            }
        }
        return newSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a, @NotNull TokenSet b) {
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i2 = 0; i2 < newSet.myWords.length; ++i2) {
            int ai = newSet.myShift - a.myShift + i2;
            int bi = newSet.myShift - b.myShift + i2;
            newSet.myWords[i2] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & (0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L);
        }
        return newSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a, @NotNull TokenSet b) {
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i2 = 0; i2 < newSet.myWords.length; ++i2) {
            int ai = newSet.myShift - a.myShift + i2;
            int bi = newSet.myShift - b.myShift + i2;
            newSet.myWords[i2] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & ((0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return newSet;
    }
}

