/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface CachedValueProvider<T> {
    @Nullable
    public Result<T> compute();

    public static class Result<T> {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.CachedValueProvider.Result");
        private final T myValue;
        private final Object[] myDependencyItems;

        public Result(@Nullable T value, Object ... dependencyItems) {
            this.myValue = value;
            this.myDependencyItems = dependencyItems;
            if (dependencyItems.length == 0) {
                LOG.error("No dependencies provided which causes CachedValue to be never recalculated again. If this is intentional, please use ModificationTracker.NEVER_CHANGED");
            }
            for (int i2 = 0; i2 < dependencyItems.length; ++i2) {
                if (dependencyItems[i2] != null) continue;
                LOG.error("Null dependencies are not allowed, index=" + i2);
            }
        }

        public T getValue() {
            return this.myValue;
        }

        @NotNull
        public Object[] getDependencyItems() {
            return this.myDependencyItems;
        }

        public static <T> Result<T> createSingleDependency(@Nullable T value, @NotNull Object dependency) {
            return Result.create(value, dependency);
        }

        public static <T> Result<T> create(@Nullable T value, Object ... dependencies) {
            return new Result<T>(value, dependencies);
        }

        public static <T> Result<T> create(@Nullable T value, @NotNull Collection<?> dependencies) {
            return new Result<T>(value, ArrayUtil.toObjectArray(dependencies));
        }
    }
}

