/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PsiClassUtil {
    private PsiClassUtil() {
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic) {
        return PsiClassUtil.isRunnableClass(aClass, mustBePublic, true);
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic, boolean mustNotBeAbstract) {
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (mustBePublic && !aClass.hasModifierProperty("public") && (mustNotBeAbstract || !aClass.hasModifierProperty("abstract"))) {
            return false;
        }
        if (aClass.hasModifierProperty("private")) {
            return false;
        }
        if (mustNotBeAbstract && aClass.hasModifierProperty("abstract")) {
            return false;
        }
        return aClass.getContainingClass() == null || aClass.hasModifierProperty("static");
    }

    @NotNull
    public static Comparator<PsiClass> createScopeComparator(@NotNull GlobalSearchScope scope) {
        return (c1, c2) -> {
            VirtualFile file1 = PsiUtilCore.getVirtualFile(c1);
            VirtualFile file2 = PsiUtilCore.getVirtualFile(c2);
            if (file1 == null) {
                return file2 == null ? 0 : -1;
            }
            if (file2 == null) {
                return 1;
            }
            return scope.compare(file2, file1);
        };
    }
}

