/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PsiTreeUtil");
    private static final Key<Integer> INDEX = Key.create((String)"PsiTreeUtil.copyElements.INDEX");
    private static final Key<Object> MARKER = Key.create((String)"PsiTreeUtil.copyElements.MARKER");

    @Contract(value="null, _, _ -> false")
    public static boolean isAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent;
        if (ancestor == null) {
            return false;
        }
        if ((ancestor instanceof StubBasedPsiElement && ((StubBasedPsiElement)ancestor).getStub() != null || element instanceof StubBasedPsiElement && ((StubBasedPsiElement)element).getStub() != null) && ancestor.getContainingFile() != element.getContainingFile()) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent = strict ? element.getParent() : element;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent instanceof PsiFile) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isContextAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent;
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent = strict ? element.getContext() : element;
        while (parent != null) {
            PsiElement context;
            if (parent.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent instanceof PsiFile && (context = parent.getContext()) == null) {
                return false;
            }
            parent = parent.getContext();
        }
        return false;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull List<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonParent(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements.length == 0) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement element : elements) {
            if (element == null) continue;
            PsiElement psiElement = toReturn = toReturn == null ? element : PsiTreeUtil.findCommonParent(toReturn, element);
            if (toReturn != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        int depth1;
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        int depth2 = PsiTreeUtil.getDepth(element2, topLevel);
        PsiElement parent1 = element1;
        PsiElement parent2 = element2;
        for (depth1 = PsiTreeUtil.getDepth(element1, topLevel); depth1 > depth2; --depth1) {
            parent1 = parent1.getParent();
        }
        while (depth2 > depth1) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    @Contract(pure=true)
    private static int getDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        int depth = 0;
        for (PsiElement parent = element; parent != topLevel && parent != null; parent = parent.getParent()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonContext(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent1;
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        int depth1 = PsiTreeUtil.getContextDepth(element1, topLevel);
        int depth2 = PsiTreeUtil.getContextDepth(element2, topLevel);
        PsiElement parent2 = element2;
        for (parent1 = element1; depth1 > depth2 && parent1 != null; parent1 = parent1.getContext(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getContext();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getContext();
            parent2 = parent2.getContext();
        }
        return parent1;
    }

    private static int getContextDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        int depth = 0;
        for (PsiElement parent = element; parent != topLevel && parent != null; parent = parent.getContext()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        return PsiTreeUtil.findChildOfAnyType(element, true, aClass);
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict) {
        return PsiTreeUtil.findChildOfAnyType(element, strict, aClass);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        return PsiTreeUtil.findChildOfAnyType(element, true, classes);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(final @Nullable PsiElement element, final boolean strict, final Class<? extends T> ... classes) {
        PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (strict && each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes)) {
                    return this.setFound(each);
                }
                return true;
            }
        };
        PsiTreeUtil.processElements(element, processor);
        return processor.getFoundElement();
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass) {
        return PsiTreeUtil.findChildrenOfAnyType(element, aClass);
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(final @Nullable PsiElement element, final Class<? extends T> ... classes) {
        if (element == null) {
            return ContainerUtil.emptyList();
        }
        PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements<T>(){

            @Override
            public boolean execute(@NotNull T each) {
                if (each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes)) {
                    return super.execute(each);
                }
                return true;
            }
        };
        PsiTreeUtil.processElements(element, processor);
        return processor.getCollection();
    }

    @Nullable
    public static <T extends PsiElement> T getChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, Condition<PsiElement> condition) {
        return PsiTreeUtil.findFirstParent(element, false, condition);
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, boolean strict, Condition<PsiElement> condition) {
        if (strict && element != null) {
            element = element.getParent();
        }
        while (element != null) {
            if (condition.value((Object)element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstContext(@Nullable PsiElement element, boolean strict, Condition<PsiElement> condition) {
        if (strict && element != null) {
            element = element.getContext();
        }
        while (element != null) {
            if (condition.value((Object)element)) {
                return element;
            }
            element = element.getContext();
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> T getRequiredChildOfType(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        T child = PsiTreeUtil.getChildOfType(element, aClass);
        assert (child != null) : "Missing required child of type " + aClass.getName();
        return child;
    }

    @Nullable
    public static <T extends PsiElement> T[] getChildrenOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            return null;
        }
        List result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(child);
        }
        return result == null ? null : (PsiElement[])ArrayUtil.toObjectArray(result, aClass);
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            return ContainerUtil.emptyList();
        }
        List result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PsiTreeUtil.instanceOf(child, classes)) continue;
            if (result == null) {
                result = ContainerUtil.newSmartList();
            }
            result.add(child);
        }
        if (result == null) {
            return ContainerUtil.emptyList();
        }
        return result;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        return result;
    }

    @Nullable
    public static <T extends PsiElement> T getStubChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        StubElement stub;
        if (element == null) {
            return null;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            return PsiTreeUtil.getChildOfType(element, aClass);
        }
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass.isInstance(child)) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getStubChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        StubElement stub;
        if (element == null) {
            return Collections.emptyList();
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            return PsiTreeUtil.getChildrenOfTypeAsList(element, aClass);
        }
        SmartList result = new SmartList();
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        return result;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes) {
        if (classes != null) {
            for (Class<?> c : classes) {
                if (!c.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(child)) continue;
                return (T)child;
            }
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNextSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass) {
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass) {
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getPrevSibling(); child != null; child = child.getPrevSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        T next;
        T answer = PsiTreeUtil.getParentOfType(element, aClass);
        while ((next = PsiTreeUtil.getParentOfType(answer, aClass)) != null) {
            answer = next;
        }
        return answer;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        return PsiTreeUtil.getParentOfType(element, aClass, true);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement element) {
        StubBase stub;
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            StubElement parentStub = stub.getParentStub();
            return parentStub != null ? (PsiElement)parentStub.getPsi() : null;
        }
        return element != null ? element.getParent() : null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <E extends PsiElement> E getStubOrPsiParentOfType(@Nullable PsiElement element, @NotNull Class<E> parentClass) {
        StubBase stub;
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            return stub.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType(element, parentClass);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !aClass.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            element = element.getContext();
        }
        return (T)element;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass, boolean strict) {
        return PsiTreeUtil.getContextOfType(element, strict, aClass);
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        return PsiTreeUtil.getContextOfType(element, true, classes);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !PsiTreeUtil.instanceOf(element, classes)) {
            element = element.getContext();
        }
        return (T)element;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict) {
        return PsiTreeUtil.getParentOfType(element, aClass, strict, -1);
    }

    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, int minStartOffset) {
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && (minStartOffset == -1 || element.getNode().getStartOffset() >= minStartOffset)) {
            if (aClass.isInstance(element)) {
                return (T)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && !aClass.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsForward(@Nullable PsiElement element, Class ... elementClasses) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsBackward(@Nullable PsiElement element, Class ... elementClasses) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipParentsOfType(@Nullable PsiElement element, Class ... parentClasses) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getParent(); e != null; e = e.getParent()) {
            if (PsiTreeUtil.instanceOf(e, parentClasses)) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        return PsiTreeUtil.getNonStrictParentOfType(parent, classes);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNonStrictParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        for (PsiElement run = element; run != null; run = run.getParent()) {
            if (PsiTreeUtil.instanceOf(run, classes)) {
                return (T)run;
            }
            if (run instanceof PsiFile) break;
        }
        return null;
    }

    @NotNull
    public static PsiElement[] collectElements(@Nullable PsiElement element, @NotNull PsiElementFilter filter) {
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(filter);
        PsiTreeUtil.processElements(element, processor);
        return processor.toArray();
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> collectElementsOfType(@Nullable PsiElement element, Class<T> ... classes) {
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(element1 -> {
            for (Class clazz : classes) {
                if (!clazz.isInstance(element1)) continue;
                return true;
            }
            return false;
        });
        PsiTreeUtil.processElements(element, processor);
        return processor.getCollection();
    }

    @Contract(value="null, _ -> true")
    public static boolean processElements(@Nullable PsiElement element, final @NotNull PsiElementProcessor processor) {
        if (element == null) {
            return true;
        }
        if (element instanceof PsiCompiledElement || !element.isPhysical()) {
            if (!processor.execute(element)) {
                return false;
            }
            for (PsiElement child : element.getChildren()) {
                if (PsiTreeUtil.processElements(child, processor)) continue;
                return false;
            }
            return true;
        }
        final boolean[] result = new boolean[]{true};
        element.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (processor.execute(element)) {
                    super.visitElement(element);
                } else {
                    this.stopWalking();
                    result[0] = false;
                }
            }
        });
        return result[0];
    }

    public static boolean processElements(@NotNull PsiElementProcessor processor, PsiElement ... elements) {
        if (elements == null || elements.length == 0) {
            return true;
        }
        for (PsiElement element : elements) {
            if (PsiTreeUtil.processElements(element, processor)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static PsiElement[] copyElements(@NotNull PsiElement[] elements) {
        int i2;
        ArrayList<PsiElement> roots = new ArrayList<PsiElement>();
        for (i2 = 0; i2 < elements.length; ++i2) {
            PsiElement rootCandidate = elements[i2];
            boolean failed = false;
            for (int j = 0; j < elements.length; ++j) {
                PsiElement element = elements[j];
                if (i2 == j || !PsiTreeUtil.isAncestor(element, rootCandidate, true)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            roots.add(rootCandidate);
        }
        for (i2 = 0; i2 < elements.length; ++i2) {
            PsiElement element = elements[i2];
            element.putCopyableUserData(INDEX, i2);
        }
        PsiElement[] newRoots = new PsiElement[roots.size()];
        for (int i3 = 0; i3 < roots.size(); ++i3) {
            PsiElement root = (PsiElement)roots.get(i3);
            newRoots[i3] = root.copy();
        }
        PsiElement[] result = new PsiElement[elements.length];
        for (PsiElement newRoot : newRoots) {
            PsiTreeUtil.decodeIndices(newRoot, result);
        }
        return result;
    }

    private static void decodeIndices(@NotNull PsiElement element, @NotNull PsiElement[] result) {
        Integer data = element.getCopyableUserData(INDEX);
        if (data != null) {
            element.putCopyableUserData(INDEX, null);
            int index = data;
            result[index] = element;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiTreeUtil.decodeIndices(child, result);
        }
    }

    public static void mark(@NotNull PsiElement element, @NotNull Object marker) {
        element.putCopyableUserData(MARKER, marker);
    }

    @Nullable
    public static PsiElement releaseMark(@NotNull PsiElement root, @NotNull Object marker) {
        if (marker.equals(root.getCopyableUserData(MARKER))) {
            root.putCopyableUserData(MARKER, null);
            return root;
        }
        for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement result = PsiTreeUtil.releaseMark(child, marker);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffset(@NotNull PsiFile file, int offset, @NotNull Class<T> clazz, boolean strictStart) {
        List<PsiFile> psiRoots = file.getViewProvider().getAllFiles();
        PsiElement result = null;
        for (PsiElement psiElement : psiRoots) {
            T parent;
            PsiElement elementAt = psiElement.findElementAt(offset);
            if (elementAt == null || (parent = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart)) == null) continue;
            TextRange range = parent.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result != null && result.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result = parent;
        }
        return (T)result;
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffsetWithStopSet(@NotNull PsiFile file, int offset, @NotNull Class<T> clazz, boolean strictStart, Class<? extends PsiElement> ... stopAt) {
        List<PsiFile> psiRoots = file.getViewProvider().getAllFiles();
        PsiElement result = null;
        for (PsiElement psiElement : psiRoots) {
            T parent;
            PsiElement elementAt = psiElement.findElementAt(offset);
            if (elementAt == null || (parent = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart, stopAt)) == null) continue;
            TextRange range = parent.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result != null && result.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result = parent;
        }
        return (T)result;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull Class<T> clazz) {
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement result = null;
        for (Language lang : viewProvider.getLanguages()) {
            T run;
            PsiElement elementAt = viewProvider.findElementAt(startOffset, lang);
            T prev = run = PsiTreeUtil.getParentOfType(elementAt, clazz, false);
            while (run != null && run.getTextRange().getStartOffset() == startOffset && run.getTextRange().getEndOffset() <= endOffset) {
                prev = run;
                run = PsiTreeUtil.getParentOfType(run, clazz);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result != null && result.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result = prev;
        }
        return (T)result;
    }

    @NotNull
    public static PsiElement getDeepestFirst(@NotNull PsiElement elt) {
        PsiElement res = elt;
        PsiElement firstChild;
        while ((firstChild = res.getFirstChild()) != null) {
            res = firstChild;
        }
        return res;
    }

    @NotNull
    public static PsiElement getDeepestLast(@NotNull PsiElement elt) {
        PsiElement res = elt;
        PsiElement lastChild;
        while ((lastChild = res.getLastChild()) != null) {
            res = lastChild;
        }
        return res;
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement current) {
        PsiElement prevSibling = current.getPrevSibling();
        if (prevSibling != null) {
            return PsiTreeUtil.lastChild(prevSibling);
        }
        PsiElement parent = current.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.prevLeaf(parent);
    }

    @Nullable
    public static PsiElement nextLeaf(@NotNull PsiElement current) {
        PsiElement nextSibling = current.getNextSibling();
        if (nextSibling != null) {
            return PsiTreeUtil.firstChild(nextSibling);
        }
        PsiElement parent = current.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.nextLeaf(parent);
    }

    public static PsiElement lastChild(@NotNull PsiElement element) {
        PsiElement lastChild = element.getLastChild();
        if (lastChild != null) {
            return PsiTreeUtil.lastChild(lastChild);
        }
        return element;
    }

    public static PsiElement firstChild(@NotNull PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child != null) {
            return PsiTreeUtil.firstChild(child);
        }
        return element;
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement element, boolean skipEmptyElements) {
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element);
        while (skipEmptyElements && prevLeaf != null && prevLeaf.getTextLength() == 0) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement prevVisibleLeaf(@NotNull PsiElement element) {
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element, true);
        while (prevLeaf != null && StringUtil.isEmptyOrSpaces((String)prevLeaf.getText())) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement nextVisibleLeaf(@NotNull PsiElement element) {
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element, true);
        while (nextLeaf != null && StringUtil.isEmptyOrSpaces((String)nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf, true);
        }
        return nextLeaf;
    }

    @Nullable
    public static PsiElement nextLeaf(PsiElement element, boolean skipEmptyElements) {
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element);
        while (skipEmptyElements && nextLeaf != null && nextLeaf.getTextLength() == 0) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf);
        }
        return nextLeaf;
    }

    public static boolean hasErrorElements(@NotNull PsiElement element) {
        return !SyntaxTraverser.psiTraverser(element).traverse().filter(PsiErrorElement.class).isEmpty();
    }

    @NotNull
    public static PsiElement[] filterAncestors(@NotNull PsiElement[] elements) {
        int previousSize;
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : elements) {
                LOG.debug("element = " + element);
            }
        }
        ArrayList filteredElements = new ArrayList();
        ContainerUtil.addAll(filteredElements, (Object[])elements);
        block1: do {
            previousSize = filteredElements.size();
            for (PsiElement element : filteredElements) {
                for (PsiElement element2 : filteredElements) {
                    if (element == element2 || !PsiTreeUtil.isAncestor(element, element2, false)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("removing " + element2);
                    }
                    filteredElements.remove(element2);
                    continue block1;
                }
            }
        } while (filteredElements.size() != previousSize);
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : filteredElements) {
                LOG.debug("filtered element = " + element);
            }
        }
        return PsiUtilCore.toPsiElementArray(filteredElements);
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state) {
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!scope.processDeclarations(processor, state, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    public static boolean treeWalkUp(@NotNull PsiElement entrance, @Nullable PsiElement maxScope, PairProcessor<PsiElement, PsiElement> eachScopeAndLastParent) {
        PsiElement prevParent = null;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!eachScopeAndLastParent.process((Object)scope, prevParent)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    @NotNull
    public static PsiElement findPrevParent(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        PsiElement cur = descendant;
        while (cur != null) {
            PsiElement parent = cur.getParent();
            if (parent == ancestor) {
                return cur;
            }
            cur = parent;
        }
        throw new AssertionError((Object)(descendant + " is not a descendant of " + ancestor));
    }

    public static List<PsiElement> getInjectedElements(@NotNull OuterLanguageElement outerLanguageElement) {
        PsiFile psi = outerLanguageElement.getContainingFile().getViewProvider().getPsi(outerLanguageElement.getLanguage());
        TextRange injectionRange = outerLanguageElement.getTextRange();
        ArrayList res = ContainerUtil.newArrayList();
        assert (psi != null) : outerLanguageElement;
        for (PsiElement element = psi.findElementAt(injectionRange.getStartOffset()); element != null && injectionRange.intersectsStrict(element.getTextRange()); element = element.getNextSibling()) {
            res.add(element);
        }
        return res;
    }

    @NotNull
    public static <T extends PsiElement> Iterator<T> childIterator(final @NotNull PsiElement element, final @NotNull Class<T> aClass) {
        return new Iterator<T>(){
            private T next;
            {
                this.next = PsiTreeUtil.getChildOfType(element, aClass);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object current = this.next;
                this.next = PsiTreeUtil.getNextSiblingOfType(current, aClass);
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

