/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiUtil
extends PsiUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PsiUtil");
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create((String)"VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final Set<String> IGNORED_NAMES = ContainerUtil.newTroveSet((Object[])new String[]{"ignore", "ignore1", "ignore2", "ignore3", "ignore4", "ignore5", "ignored", "ignored1", "ignored2", "ignored3", "ignored4", "ignored5"});
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create((String)"FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = (o1, o2) -> PsiUtil.compareElementsByPosition(o1, o2);

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(@NotNull PsiExpression expr) {
        PsiElement parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        return parent instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false);
    }

    public static boolean isAccessibleFromPackage(@NotNull PsiModifierListOwner element, @NotNull PsiPackage aPackage) {
        if (element.hasModifierProperty("public")) {
            return true;
        }
        return !element.hasModifierProperty("private") && JavaPsiFacade.getInstance(element.getProject()).isInPackage(element, aPackage);
    }

    public static boolean isAccessedForWriting(@NotNull PsiExpression expr) {
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return PsiUtil.isIncrementDecrementOperation(parent);
    }

    public static boolean isAccessedForReading(@NotNull PsiExpression expr) {
        PsiElement parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        return !(parent instanceof PsiAssignmentExpression) || !PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false) || ((PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ;
    }

    public static boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        return PsiUtil.isAccessible(place.getProject(), member, place, accessObjectClass);
    }

    public static boolean isAccessible(@NotNull Project project, @NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        return JavaPsiFacade.getInstance(project).getResolveHelper().isAccessible(member, place, accessObjectClass);
    }

    @NotNull
    public static JavaResolveResult getAccessObjectClass(@NotNull PsiExpression expression) {
        JavaResolveResult resolveResult;
        if (expression instanceof PsiSuperExpression) {
            return JavaResolveResult.EMPTY;
        }
        PsiType type = expression.getType();
        JavaResolveResult accessObject = PsiUtil.getAccessObjectClass(type, expression.getProject());
        if (accessObject != null) {
            return accessObject;
        }
        if (type == null && expression instanceof PsiReferenceExpression && (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement() instanceof PsiClass) {
            return resolveResult;
        }
        return JavaResolveResult.EMPTY;
    }

    private static JavaResolveResult getAccessObjectClass(PsiType type, Project project) {
        PsiType upperBound;
        PsiType lub;
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolveGenerics();
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolveGenerics();
        }
        if (type instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)type).getUpperBound()) instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)upperBound).resolve();
            PsiFile containingFile = resolved != null ? resolved.getContainingFile() : null;
            String packageName = containingFile instanceof PsiClassOwner ? ((PsiClassOwner)containingFile).getPackageName() : null;
            String classText = StringUtil.isEmptyOrSpaces((String)packageName) ? "" : "package " + packageName + ";\n ";
            classText = classText + "class I<T extends " + upperBound.getCanonicalText() + "> {}";
            PsiJavaFile file = (PsiJavaFile)PsiFileFactory.getInstance(project).createFileFromText("inference_dummy.java", JavaLanguage.INSTANCE, (CharSequence)classText);
            PsiTypeParameter freshParameter = file.getClasses()[0].getTypeParameters()[0];
            return new ClassCandidateInfo(freshParameter, PsiSubstitutor.EMPTY);
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.getAccessObjectClass(((PsiArrayType)type).getComponentType(), project);
        }
        return null;
    }

    public static boolean isConstantExpression(@Nullable PsiExpression expression) {
        return expression != null && JavaPsiFacade.getInstance(expression.getProject()).isConstantExpression(expression);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull @NonNls String exceptionFQName) throws IncorrectOperationException {
        PsiClass exceptionClass = JavaPsiFacade.getInstance(method.getProject()).findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull PsiClass exceptionClass) throws IncorrectOperationException {
        PsiUtil.addException(method, exceptionClass, exceptionClass.getQualifiedName());
    }

    private static void addException(@NotNull PsiMethod method, @Nullable PsiClass exceptionClass, @Nullable String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        assert (exceptionClass != null || exceptionName != null) : "One of exceptionName, exceptionClass must be not null";
        PsiReferenceList throwsList = method.getThrowsList();
        PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
        boolean replaced = false;
        for (PsiJavaCodeReferenceElement ref2 : refs) {
            if (ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass == null) continue;
            if (aClass.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                if (replaced) {
                    ref2.delete();
                    continue;
                }
                PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
                if (exceptionName != null) {
                    ref1 = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type = factory.createType(exceptionClass);
                    ref1 = factory.createReferenceElementByType(type);
                }
                ref2.replace(ref1);
                replaced = true;
                continue;
            }
            if (!exceptionClass.isInheritor(aClass, true)) continue;
            return;
        }
        if (replaced) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        if (exceptionName != null) {
            ref = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClassType type = factory.createType(exceptionClass);
            ref = factory.createReferenceElementByType(type);
        }
        throwsList.add(ref);
    }

    public static void removeException(@NotNull PsiMethod method, @NonNls String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(@NotNull String name, @NotNull PsiElement place) {
        PsiResolveHelper helper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper();
        return helper.resolveAccessibleReferencedVariable(name, place) == null;
    }

    @Nullable
    public static PsiElement getTopLevelEnclosingCodeBlock(@Nullable PsiElement element, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpression) || parent instanceof PsiLambdaExpression) {
                if (element instanceof PsiCodeBlock || element instanceof PsiForStatement || element instanceof PsiForeachStatement) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiMethod && parent.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent.getParent()) || parent instanceof PsiClassInitializer && !(parent.getParent() instanceof PsiAnonymousClass)) break;
                if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiClassLevelDeclarationStatement) {
                    parent = parent.getParent();
                }
                if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) break;
                if (element instanceof PsiFile && PsiUtilCore.getTemplateLanguageFile(element) != null) {
                    return element;
                }
            }
            if (element == scope) break;
            element = parent;
        }
        return blockSoFar;
    }

    public static boolean isLocalOrAnonymousClass(@NotNull PsiClass psiClass) {
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(@NotNull PsiClass psiClass) {
        PsiElement parent = psiClass.getParent();
        if (parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock) {
            return true;
        }
        if (parent instanceof PsiClass) {
            return PsiUtil.isLocalOrAnonymousClass((PsiClass)parent);
        }
        return false;
    }

    public static boolean isAbstractClass(@NotNull PsiClass clazz) {
        PsiModifierList modifierList = clazz.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    @Nullable
    public static PsiElement getVariableCodeBlock(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        PsiElement codeBlock = null;
        if (variable instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            } else if (declarationScope instanceof PsiLambdaExpression) {
                codeBlock = ((PsiLambdaExpression)declarationScope).getBody();
            }
        } else {
            if (variable instanceof PsiResourceVariable) {
                PsiElement resourceList = variable.getParent();
                return resourceList != null ? resourceList.getParent() : null;
            }
            if (variable instanceof PsiLocalVariable && variable.getParent() instanceof PsiForStatement) {
                return variable.getParent();
            }
            if (variable instanceof PsiField && context != null) {
                PsiClass aClass = ((PsiField)variable).getContainingClass();
                while (context != null && context.getParent() != aClass) {
                    if (!((context = context.getParent()) instanceof PsiClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context instanceof PsiMethod ? ((PsiMethod)context).getBody() : (context instanceof PsiClassInitializer ? ((PsiClassInitializer)context).getBody() : null);
            }
            PsiElement scope = variable.getParent() == null ? null : variable.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    @Contract(value="null -> false")
    public static boolean isIncrementDecrementOperation(@Nullable PsiElement element) {
        IElementType sign;
        return element instanceof PsiPostfixExpression ? (sign = ((PsiPostfixExpression)element).getOperationTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS : element instanceof PsiPrefixExpression && ((sign = ((PsiPrefixExpression)element).getOperationTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS);
    }

    @AccessLevel
    public static int getAccessLevel(@NotNull PsiModifierList modifierList) {
        if (modifierList.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getAccessModifier(@AccessLevel int accessLevel) {
        assert (accessLevel > 0 && accessLevel <= accessModifiers.length) : accessLevel;
        String modifier = accessModifiers[accessLevel - 1];
        return modifier;
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            if (!(parent instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (element != forStatement.getInitialization() && element != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element).getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof PsiExpressionStatement) {
            return PsiUtil.isStatement(((PsiExpressionStatement)element).getExpression());
        }
        if (element instanceof PsiDeclarationStatement) {
            if (parent instanceof PsiCodeBlock) {
                return true;
            }
            if (parent instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent instanceof PsiForStatement) || ((PsiForStatement)parent).getBody() == element) {
                return false;
            }
        }
        if (element instanceof PsiStatement) {
            return true;
        }
        if (element instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element)) {
            return true;
        }
        if (element instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element).getType() instanceof PsiArrayType);
        }
        return element instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getEnclosingStatement(PsiElement element) {
        while (element != null) {
            if (element.getParent() instanceof PsiCodeBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementInclusiveRange(@NotNull PsiElement scope, @NotNull TextRange range) {
        PsiElement psiElement;
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiClass resolveClassInType(@Nullable PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolve();
        }
        return null;
    }

    @Nullable
    public static PsiClass resolveClassInClassTypeOnly(@Nullable PsiType type) {
        return type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    @NotNull
    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(@Nullable PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            return classType.resolveGenerics();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveGenericsClassInType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolveGenerics();
        }
        return PsiClassType.ClassResolveResult.EMPTY;
    }

    @NotNull
    public static PsiType convertAnonymousToBaseType(@NotNull PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInType(type);
        if (psiClass instanceof PsiAnonymousClass) {
            int dims = type.getArrayDimensions();
            type = ((PsiAnonymousClass)psiClass).getBaseClassType();
            while (dims != 0) {
                type = type.createArrayType();
                --dims;
            }
        }
        return type;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpression[] argList) {
        PsiType[] types = (PsiType[])ContainerUtil.map2Array((Object[])argList, PsiType.class, PsiExpression.EXPRESSION_TO_TYPE);
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, types, PsiUtil.getLanguageLevel(method)) != 1;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList.getExpressionTypes(), PsiUtil.getLanguageLevel(argList));
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, true, true);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, allowUncheckedConversion, checkVarargs, ApplicabilityChecker.ASSIGNABILITY_CHECKER);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs, @NotNull ApplicabilityChecker function) {
        boolean isRaw;
        PsiParameter[] parms = method.getParameterList().getParameters();
        if (args.length < parms.length - 1) {
            return 1;
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor(method, substitutorForMethod) && PsiUtil.isRawSubstitutor(containingClass, substitutorForMethod);
        if (!PsiUtil.areFirstArgumentsApplicable(args, parms, languageLevel, substitutorForMethod, isRaw, allowUncheckedConversion, function)) {
            return 1;
        }
        if (args.length == parms.length) {
            PsiType erasedParamType;
            if (parms.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parms[parms.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args[args.length - 1];
            if (argType == null) {
                return 1;
            }
            if (function.isApplicable(parmType, argType, allowUncheckedConversion, parms.length - 1)) {
                return 3;
            }
            if (isRaw && (erasedParamType = TypeConversionUtil.erasure(parmType)) != null && function.isApplicable(erasedParamType, argType, allowUncheckedConversion, parms.length - 1)) {
                return 3;
            }
        }
        if (checkVarargs && method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            PsiParameter lastParameter;
            if (args.length < parms.length) {
                return 2;
            }
            PsiParameter psiParameter = lastParameter = parms.length == 0 ? null : parms[parms.length - 1];
            if (lastParameter == null || !lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            if ((lastParmType = ((PsiArrayType)lastParmType).getComponentType()) instanceof PsiCapturedWildcardType && !JavaVersionService.getInstance().isAtLeast(((PsiCapturedWildcardType)lastParmType).getContext(), JavaSdkVersion.JDK_1_8)) {
                lastParmType = ((PsiCapturedWildcardType)lastParmType).getWildcard();
            }
            if (lastParmType instanceof PsiClassType) {
                lastParmType = ((PsiClassType)lastParmType).setLanguageLevel(languageLevel);
            }
            for (int i2 = parms.length - 1; i2 < args.length; ++i2) {
                PsiType argType = args[i2];
                if (argType != null && function.isApplicable(lastParmType, argType, allowUncheckedConversion, i2)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(@NotNull PsiType[] args, @NotNull PsiParameter[] parms, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutorForMethod, boolean isRaw, boolean allowUncheckedConversion, ApplicabilityChecker function) {
        for (int i2 = 0; i2 < parms.length - 1; ++i2) {
            PsiType substErasure;
            PsiType type = args[i2];
            if (type == null) {
                return false;
            }
            PsiParameter parameter = parms[i2];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter, languageLevel, substitutorForMethod);
            if (!(isRaw ? (substErasure = TypeConversionUtil.erasure(substitutedParmType)) != null && !function.isApplicable(substErasure, type, allowUncheckedConversion, i2) : !function.isApplicable(substitutedParmType, type, allowUncheckedConversion, i2))) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(@NotNull PsiParameter parameter, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutor) {
        PsiType parmType = parameter.getType();
        if (parmType instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor.substitute(parmType);
    }

    public static boolean equalOnEquivalentClasses(PsiClassType thisClassType, @NotNull PsiClass aClass, PsiClassType otherClassType, @NotNull PsiClass bClass) {
        PsiClassType capture1 = !PsiCapturedWildcardType.isCapture() ? thisClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(thisClassType, aClass);
        PsiClassType capture2 = !PsiCapturedWildcardType.isCapture() ? otherClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(otherClassType, bClass);
        PsiClassType.ClassResolveResult result1 = capture1.resolveGenerics();
        PsiClassType.ClassResolveResult result2 = capture2.resolveGenerics();
        return PsiUtil.equalOnEquivalentClasses(result1.getSubstitutor(), aClass, result2.getSubstitutor(), bClass);
    }

    private static boolean equalOnEquivalentClasses(@NotNull PsiSubstitutor s1, @NotNull PsiClass aClass, @NotNull PsiSubstitutor s2, @NotNull PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (aClass.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i2 = 0; i2 < typeParameters1.length; ++i2) {
            PsiType substituted2 = s2.substitute(typeParameters2[i2]);
            PsiType substituted1 = s1.substitute(typeParameters1[i2]);
            if (Comparing.equal((Object)substituted1, (Object)substituted2)) continue;
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        return containingClass1 == null && containingClass2 == null;
    }

    public static boolean isCompileTimeConstant(@NotNull PsiField field) {
        return PsiUtil.isCompileTimeConstant((PsiVariable)field);
    }

    public static boolean isCompileTimeConstant(@NotNull PsiVariable field) {
        return field.hasModifierProperty("final") && (TypeConversionUtil.isPrimitiveAndNotNull(field.getType()) || field.getType().equalsToText("java.lang.String")) && field.hasInitializer() && PsiUtil.isConstantExpression(field.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(@NotNull PsiMethod[] methods) {
        if (methods.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i2 = 1; i2 < methods.length; ++i2) {
            PsiMethod method = methods[i2];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiExpression deparenthesizeExpression(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    public static boolean isInnerClass(@NotNull PsiClass aClass) {
        return !aClass.hasModifierProperty("static") && aClass.getContainingClass() != null;
    }

    @Nullable
    public static PsiElement findModifierInList(@NotNull PsiModifierList modifierList, @NonNls String modifier) {
        PsiElement[] children;
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static PsiClass getTopLevelClass(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiClassOwner) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = ((PsiClassOwner)file).getClasses()) {
                if (!PsiTreeUtil.isAncestor(aClass, element, false)) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getEnclosingStaticElement(@NotNull PsiElement place, @Nullable PsiClass aClass) {
        LOG.assertTrue(aClass == null || !place.isPhysical() || PsiTreeUtil.isContextAncestor(aClass, place, false));
        for (PsiElement parent = place; parent != aClass && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent;
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByPsiElement(@NotNull PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    @NotNull
    public static PsiType captureToplevelWildcards(@NotNull PsiType type, @NotNull PsiElement context) {
        PsiClassType.ClassResolveResult result;
        PsiClass aClass;
        if (type instanceof PsiClassType && (aClass = (result = ((PsiClassType)type).resolveGenerics()).getElement()) != null) {
            PsiSubstitutor substitutor;
            PsiSubstitutor captureSubstitutor = substitutor = result.getSubstitutor();
            for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substituted = substitutor.substitute(psiTypeParameter);
                if (!(substituted instanceof PsiWildcardType)) continue;
                captureSubstitutor = captureSubstitutor.put(psiTypeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context, psiTypeParameter));
            }
            if (captureSubstitutor != substitutor) {
                HashMap substitutionMap = null;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiCapturedWildcardType capturedWildcard;
                    PsiType substituted = substitutor.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap(substitutor.getSubstitutionMap());
                    }
                    LOG.assertTrue((capturedWildcard = (PsiCapturedWildcardType)captureSubstitutor.substitute(typeParameter)) != null);
                    PsiType upperBound = PsiCapturedWildcardType.captureUpperBound(typeParameter, (PsiWildcardType)substituted, captureSubstitutor);
                    if (upperBound != null) {
                        capturedWildcard.setUpperBound(upperBound);
                    }
                    substitutionMap.put(typeParameter, capturedWildcard);
                }
                if (substitutionMap != null) {
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
                    PsiSubstitutor newSubstitutor = psiElementFactory.createSubstitutor((Map<PsiTypeParameter, PsiType>)substitutionMap);
                    return psiElementFactory.createType(aClass, newSubstitutor);
                }
            }
        }
        return type;
    }

    public static PsiType recaptureWildcards(PsiType type, PsiElement context) {
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                PsiSubstitutor resultSubstitution = null;
                for (PsiTypeParameter parameter : substitutor.getSubstitutionMap().keySet()) {
                    PsiType substitute = substitutor.substitute(parameter);
                    if (!(substitute instanceof PsiCapturedWildcardType)) continue;
                    if (resultSubstitution == null) {
                        resultSubstitution = substitutor;
                    }
                    resultSubstitution = resultSubstitution.put(parameter, ((PsiCapturedWildcardType)substitute).getWildcard());
                }
                if (resultSubstitution != null) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory(context.getProject());
                    return PsiUtil.captureToplevelWildcards(factory.createType(aClass, resultSubstitution), context);
                }
            }
        } else if (type instanceof PsiArrayType) {
            return PsiUtil.recaptureWildcards(((PsiArrayType)type).getComponentType(), context).createArrayType();
        }
        return type;
    }

    public static boolean isInsideJavadocComment(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiDocComment.class, true) != null;
    }

    @NotNull
    public static List<PsiTypeElement> getParameterTypeElements(@NotNull PsiParameter parameter) {
        PsiTypeElement typeElement = parameter.getTypeElement();
        return typeElement != null && typeElement.getType() instanceof PsiDisjunctionType ? PsiTreeUtil.getChildrenOfTypeAsList(typeElement, PsiTypeElement.class) : Collections.singletonList(typeElement);
    }

    public static void checkIsIdentifier(@NotNull PsiManager manager, String text) throws IncorrectOperationException {
        if (!PsiNameHelper.getInstance(manager.getProject()).isIdentifier(text)) {
            throw new IncorrectOperationException(PsiBundle.message("0.is.not.an.identifier", text));
        }
    }

    @Nullable
    public static VirtualFile getJarFile(@NotNull PsiElement candidate) {
        VirtualFile file = candidate.getContainingFile().getVirtualFile();
        if (file != null && file.getFileSystem().getProtocol().equals("jar")) {
            return VfsUtilCore.getVirtualFileForJar(file);
        }
        return file;
    }

    public static boolean isAnnotationMethod(PsiElement element) {
        if (!(element instanceof PsiAnnotationMethod)) {
            return false;
        }
        PsiClass psiClass = ((PsiAnnotationMethod)element).getContainingClass();
        return psiClass != null && psiClass.isAnnotationType();
    }

    @PsiModifier.ModifierConstant
    public static String getMaximumModifierForMember(PsiClass aClass, boolean allowPublicAbstract) {
        String modifier = "public";
        if (!allowPublicAbstract && aClass.hasModifierProperty("abstract") && !aClass.isEnum()) {
            modifier = "protected";
        } else if (aClass.hasModifierProperty("packageLocal") || aClass.isEnum()) {
            modifier = "packageLocal";
        } else if (aClass.hasModifierProperty("private")) {
            modifier = "private";
        }
        return modifier;
    }

    @NotNull
    public static Iterator<PsiTypeParameter> typeParametersIterator(@NotNull PsiTypeParameterListOwner owner) {
        return PsiUtil.typeParametersIterable(owner).iterator();
    }

    @NotNull
    public static Iterable<PsiTypeParameter> typeParametersIterable(@NotNull PsiTypeParameterListOwner owner) {
        ArrayList<PsiTypeParameter> result = null;
        for (PsiTypeParameterListOwner currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currentOwner.getTypeParameters();
            if (typeParameters.length > 0) {
                if (result == null) {
                    result = new ArrayList<PsiTypeParameter>(typeParameters.length);
                }
                for (int i2 = typeParameters.length - 1; i2 >= 0; --i2) {
                    result.add(typeParameters[i2]);
                }
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result == null) {
            return EmptyIterable.getInstance();
        }
        return result;
    }

    public static boolean canBeOverriden(@NotNull PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    @NotNull
    public static PsiElement[] mapElements(@NotNull ResolveResult[] candidates) {
        PsiElement[] result = new PsiElement[candidates.length];
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            result[i2] = candidates[i2].getElement();
        }
        return result;
    }

    @Nullable
    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression) {
        PsiMember parent = (PsiMember)PsiTreeUtil.getParentOfType(expression, PsiClassInitializer.class, PsiEnumConstantInitializer.class, PsiMethod.class, PsiField.class);
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            return null;
        }
        if (parent instanceof PsiField && parent.hasModifierProperty("static")) {
            return null;
        }
        return parent;
    }

    public static boolean checkName(@NotNull PsiElement element, @NotNull String name, PsiElement context) {
        PsiMetaData data;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            return name.equals(data.getName(context));
        }
        return element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName());
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, @NotNull PsiSubstitutor substitutor) {
        if (substitutor == PsiSubstitutor.EMPTY) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanguageLevel5OrHigher(@NotNull PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_5);
    }

    public static boolean isLanguageLevel6OrHigher(@NotNull PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_6);
    }

    public static boolean isLanguageLevel7OrHigher(@NotNull PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_7);
    }

    public static boolean isLanguageLevel8OrHigher(@NotNull PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_8);
    }

    public static boolean isLanguageLevel9OrHigher(@NotNull PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_9);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        PsiElement context;
        if (element instanceof PsiDirectory) {
            return JavaDirectoryService.getInstance().getLanguageLevel((PsiDirectory)element);
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiJavaFile) {
            return ((PsiJavaFile)file).getLanguageLevel();
        }
        if (file != null && (context = file.getContext()) != null) {
            if (!context.isValid()) {
                throw new PsiInvalidElementAccessException(context, "Invalid context in " + file + " of " + file.getClass());
            }
            return PsiUtil.getLanguageLevel(context);
        }
        PsiResolveHelper instance = PsiResolveHelper.SERVICE.getInstance(element.getProject());
        return instance != null ? instance.getEffectiveLanguageLevel(PsiUtil.getVirtualFile(file)) : LanguageLevel.HIGHEST;
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull Project project) {
        LanguageLevelProjectExtension instance = LanguageLevelProjectExtension.getInstance(project);
        return instance != null ? instance.getLanguageLevel() : LanguageLevel.HIGHEST;
    }

    public static boolean isInstantiatable(@NotNull PsiClass clazz) {
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz) {
        return PsiUtil.hasDefaultConstructor(clazz, false);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected) {
        return PsiUtil.hasDefaultConstructor(clazz, allowProtected, true);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected, boolean checkModifiers) {
        return PsiUtil.hasDefaultCtrInHierarchy(clazz, allowProtected, checkModifiers, null);
    }

    private static boolean hasDefaultCtrInHierarchy(@NotNull PsiClass clazz, boolean allowProtected, boolean checkModifiers, @Nullable Set<PsiClass> visited) {
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod cls : constructors) {
                if (checkModifiers && !cls.hasModifierProperty("public") && (!allowProtected || !cls.hasModifierProperty("protected")) || cls.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
        } else {
            PsiClass superClass = clazz.getSuperClass();
            if (superClass == null) {
                return true;
            }
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)clazz)) {
                return false;
            }
            return PsiUtil.hasDefaultCtrInHierarchy(superClass, true, true, (Set<PsiClass>)visited);
        }
        return false;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiType extractIterableTypeParameter(@Nullable PsiType psiType, boolean eraseTypeParameter) {
        PsiType type = PsiUtil.substituteTypeParameter(psiType, "java.lang.Iterable", 0, eraseTypeParameter);
        return type != null ? type : PsiUtil.substituteTypeParameter(psiType, "java.util.Collection", 0, eraseTypeParameter);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType, @NotNull String superClass, int typeParamIndex, boolean eraseTypeParameter) {
        if (psiType == null) {
            return null;
        }
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(superClass, psiClass.getResolveScope());
        if (baseClass == null) {
            return null;
        }
        if (!psiClass.isEquivalentTo(baseClass) && !psiClass.isInheritor(baseClass, true)) {
            return null;
        }
        PsiTypeParameter[] parameters = baseClass.getTypeParameters();
        if (parameters.length <= typeParamIndex) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(baseClass, psiClass, classResolveResult.getSubstitutor());
        PsiType type = substitutor.substitute(parameters[typeParamIndex]);
        if (type == null && eraseTypeParameter) {
            return TypeConversionUtil.typeParameterErasure(parameters[typeParamIndex]);
        }
        return type;
    }

    public static void setModifierProperty(@NotNull PsiModifierListOwner owner, @NotNull @PsiModifier.ModifierConstant String property, boolean value) {
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null) : owner;
        modifierList.setModifierProperty(property, value);
    }

    public static boolean isTryBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiTryStatement && element == ((PsiTryStatement)parent).getTryBlock();
    }

    public static boolean isElseBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getElseBranch();
    }

    public static boolean isJavaToken(@Nullable PsiElement element, IElementType type) {
        return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == type;
    }

    public static boolean isJavaToken(@Nullable PsiElement element, @NotNull TokenSet types) {
        return element instanceof PsiJavaToken && types.contains(((PsiJavaToken)element).getTokenType());
    }

    public static boolean isCatchParameter(@Nullable PsiElement element) {
        return element instanceof PsiParameter && element.getParent() instanceof PsiCatchSection;
    }

    public static boolean isIgnoredName(@Nullable String name) {
        return name != null && IGNORED_NAMES.contains(name);
    }

    @Nullable
    public static PsiMethod[] getResourceCloserMethodsForType(@NotNull PsiClassType resourceType) {
        PsiClass resourceClass = resourceType.resolve();
        if (resourceClass == null) {
            return null;
        }
        Project project = resourceClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass autoCloseable = facade.findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope(project));
        if (autoCloseable == null) {
            return null;
        }
        if (JavaClassSupers.getInstance().getSuperClassSubstitutor(autoCloseable, resourceClass, resourceType.getResolveScope(), PsiSubstitutor.EMPTY) == null) {
            return null;
        }
        PsiMethod[] closes = autoCloseable.findMethodsByName("close", false);
        if (closes.length == 1) {
            return resourceClass.findMethodsBySignature(closes[0], true);
        }
        return null;
    }

    @Nullable
    public static PsiExpression skipParenthesizedExprDown(PsiExpression initializer) {
        while (initializer instanceof PsiParenthesizedExpression) {
            initializer = ((PsiParenthesizedExpression)initializer).getExpression();
        }
        return initializer;
    }

    public static PsiElement skipParenthesizedExprUp(PsiElement parent) {
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static void ensureValidType(@NotNull PsiType type) {
        PsiUtil.ensureValidType(type, null);
    }

    public static void ensureValidType(@NotNull PsiType type, @Nullable String customMessage) {
        if (!type.isValid()) {
            TimeoutUtil.sleep((long)1L);
            if (type.isValid()) {
                LOG.error("PsiType resurrected: " + type + " of " + type.getClass() + " " + customMessage);
                return;
            }
            if (type instanceof PsiClassType) {
                try {
                    PsiClass psiClass = ((PsiClassType)type).resolve();
                    if (psiClass != null) {
                        PsiUtil.ensureValid(psiClass);
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    throw customMessage == null ? e : new RuntimeException(customMessage, e);
                }
            }
            throw new AssertionError((Object)("Invalid type: " + type + " of class " + type.getClass() + " " + customMessage));
        }
    }

    @Nullable
    public static String getMemberQualifiedName(@NotNull PsiMember member) {
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        return className + "." + member.getName();
    }

    public static boolean isFromDefaultPackage(PsiClass aClass) {
        PsiFile containingFile = aClass.getContainingFile();
        return containingFile instanceof PsiClassOwner && StringUtil.isEmpty((String)((PsiClassOwner)containingFile).getPackageName());
    }

    static boolean checkSameExpression(PsiElement templateExpr, PsiExpression expression) {
        return templateExpr.equals(PsiUtil.skipParenthesizedExprDown(expression));
    }

    public static boolean isCondition(PsiElement expr, PsiElement parent) {
        return parent instanceof PsiIfStatement ? PsiUtil.checkSameExpression(expr, ((PsiIfStatement)parent).getCondition()) : (parent instanceof PsiWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiWhileStatement)parent).getCondition()) : (parent instanceof PsiForStatement ? PsiUtil.checkSameExpression(expr, ((PsiForStatement)parent).getCondition()) : (parent instanceof PsiDoWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiDoWhileStatement)parent).getCondition()) : parent instanceof PsiConditionalExpression && PsiUtil.checkSameExpression(expr, ((PsiConditionalExpression)parent).getCondition()))));
    }

    @NotNull
    public static PsiReturnStatement[] findReturnStatements(@NotNull PsiMethod method) {
        return PsiUtil.findReturnStatements(method.getBody());
    }

    @NotNull
    public static PsiReturnStatement[] findReturnStatements(@Nullable PsiCodeBlock body) {
        ArrayList<PsiReturnStatement> vector = new ArrayList<PsiReturnStatement>();
        if (body != null) {
            PsiUtil.addReturnStatements(vector, body);
        }
        return vector.toArray(new PsiReturnStatement[vector.size()]);
    }

    private static void addReturnStatements(ArrayList<PsiReturnStatement> vector, PsiElement element) {
        if (element instanceof PsiReturnStatement) {
            vector.add((PsiReturnStatement)element);
        } else if (!(element instanceof PsiClass) && !(element instanceof PsiLambdaExpression)) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                PsiUtil.addReturnStatements(vector, child);
            }
        }
    }

    public static boolean isModuleFile(@NotNull PsiFile file) {
        return file instanceof PsiJavaFile && ((PsiJavaFile)file).getModuleDeclaration() != null;
    }

    public static boolean isPackageEmpty(@NotNull PsiDirectory[] directories, @NotNull String packageName) {
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (!(file instanceof PsiClassOwner) || !packageName.equals(((PsiClassOwner)file).getPackageName()) || ((PsiClassOwner)file).getClasses().length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static PsiModifierListOwner preferCompiledElement(@NotNull PsiModifierListOwner element) {
        PsiElement original = element.getOriginalElement();
        return original instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : element;
    }

    public static interface ApplicabilityChecker {
        public static final ApplicabilityChecker ASSIGNABILITY_CHECKER = new ApplicabilityChecker(){

            @Override
            public boolean isApplicable(PsiType left, PsiType right, boolean allowUncheckedConversion, int argId) {
                return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
            }
        };

        public boolean isApplicable(PsiType var1, PsiType var2, boolean var3, int var4);
    }

    public static @interface AccessLevel {
    }
}

