/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightVirtualFileBase
extends VirtualFile {
    private FileType myFileType;
    private String myName = "";
    private long myModStamp = LocalTimeCounter.currentTime();
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFileBase(String name, FileType fileType, long modificationStamp) {
        this.myName = name;
        this.myFileType = fileType;
        this.myModStamp = modificationStamp;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return ourFileSystem;
    }

    @Nullable
    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        if (this.myOriginalFile != null) {
            return this.myOriginalFile.getFileType();
        }
        return super.getFileType();
    }

    @Override
    @NotNull
    public String getPath() {
        return "/" + this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    protected void setModificationStamp(long stamp) {
        this.myModStamp = stamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName) throws IOException {
        this.assertWritable();
        this.myName = newName;
    }

    void assertWritable() {
        if (!this.isWritable()) {
            throw new IncorrectOperationException("File is not writable: " + this);
        }
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        this.assertWritable();
        return super.createChildDirectory(requestor, name);
    }

    @Override
    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        this.assertWritable();
        return super.createChildData(requestor, name);
    }

    @Override
    public void delete(Object requestor) throws IOException {
        this.assertWritable();
        super.delete(requestor);
    }

    @Override
    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        this.assertWritable();
        super.move(requestor, newParent);
    }

    @Override
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, newTimeStamp);
    }

    @Override
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long newTimeStamp, Object requestor) throws IOException {
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
    }

    private static class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        @NonNls
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        @NotNull
        public String getProtocol() {
            return PROTOCOL;
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path2) {
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
            return null;
        }
    }
}

