/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckBoxList<T>
extends JBList {
    private final CellRenderer myCellRenderer;
    private CheckBoxListListener checkBoxListListener;
    private final BidirectionalMap<T, JCheckBox> myItemMap = new BidirectionalMap();

    public CheckBoxList(CheckBoxListListener checkBoxListListener) {
        this(new DefaultListModel(), checkBoxListListener);
    }

    public CheckBoxList(DefaultListModel dataModel, CheckBoxListListener checkBoxListListener) {
        this(dataModel);
        this.setCheckBoxListListener(checkBoxListListener);
    }

    public CheckBoxList() {
        this(new DefaultListModel());
    }

    public CheckBoxList(DefaultListModel dataModel) {
        this.setModel(dataModel);
        this.myCellRenderer = new CellRenderer();
        this.setCellRenderer(this.myCellRenderer);
        this.setSelectionMode(0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    Boolean value = null;
                    for (int index : CheckBoxList.this.getSelectedIndices()) {
                        if (index < 0) continue;
                        JCheckBox checkbox = CheckBoxList.this.getCheckBoxAt(index);
                        value = value != null ? value : !checkbox.isSelected();
                        CheckBoxList.this.setSelected(checkbox, index, value);
                    }
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int index;
                if (CheckBoxList.this.isEnabled() && (index = CheckBoxList.this.locationToIndex(e.getPoint())) != -1) {
                    JCheckBox checkBox = CheckBoxList.this.getCheckBoxAt(index);
                    Rectangle bounds = CheckBoxList.this.getCellBounds(index, index);
                    if (bounds == null) {
                        return false;
                    }
                    Point p = CheckBoxList.this.findPointRelativeToCheckBox(e.getX() - bounds.x, e.getY() - bounds.y, checkBox, index);
                    if (p != null) {
                        Dimension dim = CheckBoxList.getCheckBoxDimension(checkBox);
                        if (p.x >= 0 && p.x < dim.width && p.y >= 0 && p.y < dim.height) {
                            CheckBoxList.this.setSelected(checkBox, index, !checkBox.isSelected());
                            return true;
                        }
                    }
                }
                return false;
            }
        }.installOn((Component)this);
    }

    @NotNull
    private static Dimension getCheckBoxDimension(@NotNull JCheckBox checkBox) {
        Icon icon = null;
        BasicRadioButtonUI ui = (BasicRadioButtonUI)ObjectUtils.tryCast((Object)checkBox.getUI(), BasicRadioButtonUI.class);
        if (ui != null) {
            icon = ui.getDefaultIcon();
        }
        if (icon == null) {
            icon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)20));
        }
        Insets margin = checkBox.getMargin();
        return new Dimension(margin.left + icon.getIconWidth(), margin.top + icon.getIconHeight());
    }

    @Nullable
    protected Point findPointRelativeToCheckBox(int x, int y, @NotNull JCheckBox checkBox, int index) {
        int cx = x - ((CellRenderer)this.myCellRenderer).getBorderInsets().left;
        int cy = y - ((CellRenderer)this.myCellRenderer).getBorderInsets().top;
        return cx >= 0 && cy >= 0 ? new Point(cx, cy) : null;
    }

    @Nullable
    protected Point findPointRelativeToCheckBoxWithAdjustedRendering(int x, int y, @NotNull JCheckBox checkBox, int index) {
        Point checkBoxLocation;
        Container c;
        Component found;
        boolean selected = this.isSelectedIndex(index);
        boolean hasFocus = this.hasFocus();
        Component component = this.myCellRenderer.getListCellRendererComponent((JList)this, checkBox, index, selected, hasFocus);
        Rectangle bounds = this.getCellBounds(index, index);
        bounds.x = 0;
        bounds.y = 0;
        component.setBounds(bounds);
        if (component instanceof Container && (found = (c = (Container)component).findComponentAt(x, y)) == checkBox && (checkBoxLocation = CheckBoxList.getChildLocationRelativeToAncestor(component, checkBox)) != null) {
            return new Point(x - checkBoxLocation.x, y - checkBoxLocation.y);
        }
        return null;
    }

    @Nullable
    private static Point getChildLocationRelativeToAncestor(@NotNull Component ancestor, @NotNull Component child) {
        int dx = 0;
        int dy = 0;
        Component c = child;
        while (c != null && c != ancestor) {
            Point p = c.getLocation();
            dx += p.x;
            dy += p.y;
            c = child.getParent();
        }
        return c == ancestor ? new Point(dx, dy) : null;
    }

    @NotNull
    private JCheckBox getCheckBoxAt(int index) {
        return (JCheckBox)this.getModel().getElementAt(index);
    }

    public void setStringItems(Map<String, Boolean> items) {
        this.clear();
        for (Map.Entry<String, Boolean> entry : items.entrySet()) {
            this.addItem(entry.getKey(), entry.getKey(), entry.getValue());
        }
    }

    public void setItems(List<T> items, @Nullable Function<T, String> converter) {
        this.clear();
        for (T item : items) {
            String text = converter != null ? (String)converter.fun(item) : item.toString();
            this.addItem(item, text, false);
        }
    }

    public void addItem(T item, String text, boolean selected) {
        JCheckBox checkBox = new JCheckBox(text, selected);
        checkBox.setOpaque(true);
        this.myItemMap.put(item, (Object)checkBox);
        ((DefaultListModel)this.getModel()).addElement(checkBox);
    }

    public void updateItem(@NotNull T oldItem, @NotNull T newItem, @NotNull String newText) {
        JCheckBox checkBox = (JCheckBox)this.myItemMap.remove(oldItem);
        this.myItemMap.put(newItem, (Object)checkBox);
        checkBox.setText(newText);
        DefaultListModel model = (DefaultListModel)this.getModel();
        int ind = model.indexOf(checkBox);
        if (ind >= 0) {
            model.set(ind, checkBox);
        }
    }

    @Nullable
    public T getItemAt(int index) {
        JCheckBox checkBox = (JCheckBox)this.getModel().getElementAt(index);
        List value = this.myItemMap.getKeysByValue((Object)checkBox);
        return value == null || value.isEmpty() ? null : (T)value.get(0);
    }

    public void clear() {
        ((DefaultListModel)this.getModel()).clear();
        this.myItemMap.clear();
    }

    public boolean isItemSelected(int index) {
        return ((JCheckBox)this.getModel().getElementAt(index)).isSelected();
    }

    public boolean isItemSelected(T item) {
        JCheckBox checkBox = (JCheckBox)this.myItemMap.get(item);
        return checkBox != null && checkBox.isSelected();
    }

    public void setItemSelected(T item, boolean selected) {
        JCheckBox checkBox = (JCheckBox)this.myItemMap.get(item);
        if (checkBox != null) {
            checkBox.setSelected(selected);
        }
    }

    private void setSelected(JCheckBox checkbox, int index, boolean value) {
        checkbox.setSelected(value);
        this.repaint();
        ListModel model = this.getModel();
        if (model instanceof DefaultListModel) {
            ((DefaultListModel)model).setElementAt(this.getModel().getElementAt(index), index);
        }
        if (this.checkBoxListListener != null) {
            this.checkBoxListListener.checkBoxSelectionChanged(index, value);
        }
    }

    public void setCheckBoxListListener(CheckBoxListListener checkBoxListListener) {
        this.checkBoxListListener = checkBoxListListener;
    }

    protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
        return rootComponent;
    }

    @Nullable
    protected String getSecondaryText(int index) {
        return null;
    }

    protected Color getBackground(boolean isSelected) {
        return isSelected ? this.getSelectionBackground() : this.getBackground();
    }

    protected Color getForeground(boolean isSelected) {
        return isSelected ? this.getSelectionForeground() : this.getForeground();
    }

    private class CellRenderer
    implements ListCellRenderer {
        private final Border mySelectedBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        private final Border myBorder;
        private final Insets myBorderInsets = this.mySelectedBorder.getBorderInsets(new JCheckBox());

        private CellRenderer() {
            this.myBorder = new EmptyBorder(this.myBorderInsets);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent rootComponent;
            boolean shouldAdjustColors;
            JCheckBox checkbox = (JCheckBox)value;
            Color textColor = CheckBoxList.this.getForeground(isSelected);
            Color backgroundColor = CheckBoxList.this.getBackground(isSelected);
            Font font = CheckBoxList.this.getFont();
            boolean bl = shouldAdjustColors = !UIUtil.isUnderNimbusLookAndFeel();
            if (shouldAdjustColors) {
                checkbox.setBackground(backgroundColor);
                checkbox.setForeground(textColor);
                checkbox.setOpaque(true);
            }
            checkbox.setEnabled(CheckBoxList.this.isEnabled());
            checkbox.setFont(font);
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(false);
            checkbox.setOpaque(true);
            String auxText = CheckBoxList.this.getSecondaryText(index);
            if (auxText != null) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)checkbox, "Before");
                JLabel infoLabel = new JLabel(auxText, 4);
                infoLabel.setBorder(new EmptyBorder(0, 0, 0, checkbox.getInsets().left));
                infoLabel.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)font));
                panel.add((Component)infoLabel, "Center");
                if (shouldAdjustColors) {
                    panel.setBackground(backgroundColor);
                    infoLabel.setForeground(isSelected ? textColor : JBColor.GRAY);
                    infoLabel.setBackground(backgroundColor);
                }
                rootComponent = panel;
            } else {
                rootComponent = checkbox;
            }
            rootComponent.setBorder(isSelected ? this.mySelectedBorder : this.myBorder);
            rootComponent = CheckBoxList.this.adjustRendering(rootComponent, checkbox, index, isSelected, cellHasFocus);
            return rootComponent;
        }

        @NotNull
        private Insets getBorderInsets() {
            return this.myBorderInsets;
        }
    }
}

