/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxTreeHelper {
    private static final Key<Runnable> TREE_LISTENERS_REMOVER = Key.create((String)"TREE_LISTENERS_REMOVER");
    public static final CheckboxTreeBase.CheckPolicy DEFAULT_POLICY = new CheckboxTreeBase.CheckPolicy(true, true, false, true);
    private final CheckboxTreeBase.CheckPolicy myCheckPolicy;
    private final EventDispatcher<CheckboxTreeListener> myEventDispatcher;

    public CheckboxTreeHelper(@NotNull CheckboxTreeBase.CheckPolicy checkPolicy, @NotNull EventDispatcher<CheckboxTreeListener> dispatcher) {
        this.myCheckPolicy = checkPolicy;
        this.myEventDispatcher = dispatcher;
    }

    public void initTree(@NotNull Tree tree, JComponent mainComponent, CheckboxTreeBase.CheckboxTreeCellRendererBase cellRenderer) {
        CheckboxTreeHelper.removeTreeListeners(mainComponent);
        tree.setCellRenderer(cellRenderer);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setLineStyleAngled();
        TreeUtil.installActions(tree);
        KeyListener keyListener = this.setupKeyListener(tree, mainComponent);
        ClickListener clickListener = this.setupMouseListener(tree, mainComponent, cellRenderer);
        UIUtil.putClientProperty((JComponent)mainComponent, TREE_LISTENERS_REMOVER, () -> {
            mainComponent.removeKeyListener(keyListener);
            clickListener.uninstall((Component)mainComponent);
        });
    }

    public void setNodeState(Tree tree, CheckedTreeNode node, boolean checked) {
        this.changeNodeState(node, checked);
        this.adjustParentsAndChildren(node, checked);
        tree.repaint();
        TreeModel model = tree.getModel();
        model.valueForPathChanged(new TreePath(node.getPath()), node.getUserObject());
    }

    private void toggleNode(Tree tree, CheckedTreeNode node) {
        this.setNodeState(tree, node, !node.isChecked());
    }

    private void adjustParentsAndChildren(CheckedTreeNode node, boolean checked) {
        if (!checked) {
            if (this.myCheckPolicy.uncheckParentWithUncheckedChild) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, false);
                }
            }
            if (this.myCheckPolicy.uncheckChildrenWithUncheckedParent) {
                this.uncheckChildren(node);
            }
        } else {
            if (this.myCheckPolicy.checkChildrenWithCheckedParent) {
                this.checkChildren(node);
            }
            if (this.myCheckPolicy.checkParentWithCheckedChild) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, true);
                }
            }
        }
    }

    private void changeNodeState(CheckedTreeNode node, boolean checked) {
        if (node.isChecked() != checked) {
            ((CheckboxTreeListener)this.myEventDispatcher.getMulticaster()).beforeNodeStateChanged(node);
            node.setChecked(checked);
            ((CheckboxTreeListener)this.myEventDispatcher.getMulticaster()).nodeStateChanged(node);
        }
    }

    private void uncheckChildren(CheckedTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            this.changeNodeState(child, false);
            this.uncheckChildren(child);
        }
    }

    private void checkChildren(CheckedTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            this.changeNodeState(child, true);
            this.checkChildren(child);
        }
    }

    private KeyListener setupKeyListener(final Tree tree, final JComponent mainComponent) {
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (CheckboxTreeHelper.isToggleEvent(e, mainComponent)) {
                    TreePath treePath = tree.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object o = treePath.getLastPathComponent();
                    if (!(o instanceof CheckedTreeNode)) {
                        return;
                    }
                    CheckedTreeNode firstNode = (CheckedTreeNode)o;
                    if (!firstNode.isEnabled()) {
                        return;
                    }
                    CheckboxTreeHelper.this.toggleNode(tree, firstNode);
                    boolean checked = firstNode.isChecked();
                    TreePath[] selectionPaths = tree.getSelectionPaths();
                    for (int i2 = 0; selectionPaths != null && i2 < selectionPaths.length; ++i2) {
                        TreePath selectionPath = selectionPaths[i2];
                        Object o1 = selectionPath.getLastPathComponent();
                        if (!(o1 instanceof CheckedTreeNode)) continue;
                        CheckedTreeNode node = (CheckedTreeNode)o1;
                        CheckboxTreeHelper.this.setNodeState(tree, node, checked);
                    }
                    e.consume();
                }
            }
        };
        mainComponent.addKeyListener(listener);
        return listener;
    }

    public static boolean isToggleEvent(KeyEvent e, JComponent mainComponent) {
        return e.getKeyCode() == 32 && SpeedSearchSupply.getSupply(mainComponent) == null;
    }

    private ClickListener setupMouseListener(final Tree tree, JComponent mainComponent, final CheckboxTreeBase.CheckboxTreeCellRendererBase cellRenderer) {
        ClickListener listener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = tree.getPathForRow(row).getLastPathComponent();
                if (!(o instanceof CheckedTreeNode)) {
                    return false;
                }
                Rectangle rowBounds = tree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = checkBounds.width = rowBounds.height;
                }
                CheckedTreeNode node = (CheckedTreeNode)o;
                if (checkBounds.contains(e.getPoint())) {
                    if (node.isEnabled()) {
                        CheckboxTreeHelper.this.toggleNode(tree, node);
                        tree.setSelectionRow(row);
                        return true;
                    }
                } else if (clickCount > 1 && clickCount % 2 == 0) {
                    ((CheckboxTreeListener)CheckboxTreeHelper.this.myEventDispatcher.getMulticaster()).mouseDoubleClicked(node);
                    return true;
                }
                return false;
            }
        };
        listener.installOn((Component)mainComponent);
        return listener;
    }

    private static void removeTreeListeners(JComponent mainComponent) {
        Runnable remover = (Runnable)UIUtil.getClientProperty((Object)mainComponent, TREE_LISTENERS_REMOVER);
        if (remover != null) {
            remover.run();
        }
    }

    public static <T> T[] getCheckedNodes(final Class<T> nodeType, final @Nullable Tree.NodeFilter<T> filter, TreeModel model) {
        final ArrayList nodes = new ArrayList();
        Object root = model.getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            throw new IllegalStateException("The root must be instance of the " + CheckedTreeNode.class.getName() + ": " + root.getClass().getName());
        }
        new Object(){

            public void collect(CheckedTreeNode node) {
                if (node.isLeaf()) {
                    Object userObject = node.getUserObject();
                    if (node.isChecked() && userObject != null && nodeType.isAssignableFrom(userObject.getClass())) {
                        Object value = userObject;
                        if (filter != null && !filter.accept(value)) {
                            return;
                        }
                        nodes.add(value);
                    }
                } else {
                    for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                        TreeNode child = node.getChildAt(i2);
                        if (!(child instanceof CheckedTreeNode)) continue;
                        this.collect((CheckedTreeNode)child);
                    }
                }
            }
        }.collect((CheckedTreeNode)root);
        Object[] result = (Object[])Array.newInstance(nodeType, nodes.size());
        nodes.toArray(result);
        return result;
    }
}

