/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public class ExpandedItemListCellRendererWrapper
implements ListCellRenderer {
    @NotNull
    private final ListCellRenderer myWrappee;
    @NotNull
    private final ExpandableItemsHandler<Integer> myHandler;

    public ExpandedItemListCellRendererWrapper(@NotNull ListCellRenderer wrappee, @NotNull ExpandableItemsHandler<Integer> handler) {
        this.myWrappee = wrappee;
        this.myHandler = handler;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        list.putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, AntialiasingType.getAAHintForSwingComponent());
        Component result = this.myWrappee.getListCellRendererComponent(list, UIUtil.htmlInjectionGuard((Object)value), index, isSelected, cellHasFocus);
        if (!this.myHandler.getExpandedItems().contains(index)) {
            return result;
        }
        Rectangle bounds = result.getBounds();
        ExpandedItemRendererComponentWrapper wrapper = ExpandedItemRendererComponentWrapper.wrap(result);
        if (UIUtil.isClientPropertyTrue((Object)list, ExpandableItemsHandler.EXPANDED_RENDERER) && UIUtil.isClientPropertyTrue((Object)result, ExpandableItemsHandler.USE_RENDERER_BOUNDS)) {
            wrapper.setBounds(bounds);
            UIUtil.putClientProperty((JComponent)wrapper, ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)true);
        }
        wrapper.owner = list;
        return wrapper;
    }

    public String toString() {
        return "ExpandedItemListCellRendererWrapper[" + this.getWrappee().getClass().getName() + "]";
    }

    @NotNull
    public ListCellRenderer getWrappee() {
        return this.myWrappee;
    }
}

