/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBSplitter
extends Splitter {
    @Nullable
    private String mySplitterProportionKey = null;
    private final float myDefaultProportion;

    public JBSplitter() {
        this.myDefaultProportion = 0.5f;
    }

    public JBSplitter(@NotNull String proportionKey, float defaultProportion) {
        this(false, proportionKey, defaultProportion);
    }

    public JBSplitter(boolean vertical, @NotNull String proportionKey, float defaultProportion) {
        super(vertical, defaultProportion);
        this.mySplitterProportionKey = proportionKey;
        this.myDefaultProportion = defaultProportion;
    }

    public JBSplitter(boolean vertical) {
        super(vertical);
        this.myDefaultProportion = 0.5f;
    }

    public JBSplitter(boolean vertical, float proportion) {
        super(vertical, proportion);
        this.myDefaultProportion = proportion;
    }

    public JBSplitter(float proportion) {
        super(false, proportion);
        this.myDefaultProportion = proportion;
    }

    public JBSplitter(boolean vertical, float proportion, float minProp, float maxProp) {
        super(vertical, proportion, minProp, maxProp);
        this.myDefaultProportion = proportion;
    }

    @Nullable
    public final String getSplitterProportionKey() {
        return this.mySplitterProportionKey;
    }

    public final void setSplitterProportionKey(@Nullable String key) {
        this.mySplitterProportionKey = key;
    }

    public final void setAndLoadSplitterProportionKey(@NotNull String key) {
        this.setSplitterProportionKey(key);
        this.loadProportion();
    }

    public void addNotify() {
        super.addNotify();
        this.loadProportion();
    }

    public void setProportion(float proportion) {
        super.setProportion(proportion);
        this.saveProportion();
    }

    protected void loadProportion() {
        if (!StringUtil.isEmpty((String)this.mySplitterProportionKey)) {
            this.setProportion(PropertiesComponent.getInstance().getFloat(this.mySplitterProportionKey, this.myProportion));
        }
    }

    protected void saveProportion() {
        if (!StringUtil.isEmpty((String)this.mySplitterProportionKey)) {
            PropertiesComponent.getInstance().setValue(this.mySplitterProportionKey, this.myProportion, this.myDefaultProportion);
        }
    }
}

