/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleTextAttributes {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int FONT_MASK = 3;
    public static final int STYLE_STRIKEOUT = 4;
    public static final int STYLE_WAVED = 8;
    public static final int STYLE_UNDERLINE = 16;
    public static final int STYLE_BOLD_DOTTED_LINE = 32;
    public static final int STYLE_SEARCH_MATCH = 64;
    public static final int STYLE_SMALLER = 128;
    public static final int STYLE_OPAQUE = 256;
    public static final SimpleTextAttributes REGULAR_ATTRIBUTES = new SimpleTextAttributes(0, null);
    public static final SimpleTextAttributes REGULAR_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, null);
    public static final SimpleTextAttributes REGULAR_ITALIC_ATTRIBUTES = new SimpleTextAttributes(2, null);
    public static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, (Color)JBColor.red);
    public static final SimpleTextAttributes GRAYED_ATTRIBUTES = new SimpleTextAttributes(0, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes GRAYED_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes GRAYED_ITALIC_ATTRIBUTES = new SimpleTextAttributes(2, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes GRAYED_SMALL_ATTRIBUTES = new SimpleTextAttributes(128, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes SYNTHETIC_ATTRIBUTES = new SimpleTextAttributes(0, (Color)JBColor.blue);
    public static final SimpleTextAttributes GRAY_ATTRIBUTES = new SimpleTextAttributes(0, Color.GRAY);
    public static final SimpleTextAttributes GRAY_ITALIC_ATTRIBUTES = new SimpleTextAttributes(2, Color.GRAY);
    public static final SimpleTextAttributes DARK_TEXT = new SimpleTextAttributes(0, new Color(112, 112, 164));
    public static final SimpleTextAttributes SIMPLE_CELL_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor((Color)Gray._0, (Color)Gray._187));
    public static final SimpleTextAttributes SELECTED_SIMPLE_CELL_ATTRIBUTES = new SimpleTextAttributes(0, UIUtil.getListSelectionForeground());
    public static final SimpleTextAttributes EXCLUDED_ATTRIBUTES = new SimpleTextAttributes(2, Color.GRAY);
    public static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(16, (Color)JBColor.blue);
    public static final SimpleTextAttributes LINK_BOLD_ATTRIBUTES = new SimpleTextAttributes(17, (Color)JBColor.blue);
    private final Color myBgColor;
    private final Color myFgColor;
    private final Color myWaveColor;
    @StyleAttributeConstant
    private final int myStyle;

    public SimpleTextAttributes(@StyleAttributeConstant int style, Color fgColor) {
        this(style, fgColor, null);
    }

    public SimpleTextAttributes(@StyleAttributeConstant int style, Color fgColor, @Nullable Color waveColor) {
        this(null, fgColor, waveColor, style);
    }

    public SimpleTextAttributes(@Nullable Color bgColor, Color fgColor, @Nullable Color waveColor, @StyleAttributeConstant int style) {
        if ((0xFFFFFE00 & style) != 0) {
            throw new IllegalArgumentException("Wrong style: " + style);
        }
        this.myBgColor = bgColor;
        this.myFgColor = fgColor;
        this.myWaveColor = waveColor;
        this.myStyle = style;
    }

    public Color getFgColor() {
        return this.myFgColor;
    }

    @Nullable
    public Color getBgColor() {
        return this.myBgColor;
    }

    @Nullable
    public Color getWaveColor() {
        return this.myWaveColor;
    }

    @StyleAttributeConstant
    public int getStyle() {
        return this.myStyle;
    }

    public boolean isStrikeout() {
        return BitUtil.isSet((int)this.myStyle, (int)4);
    }

    public boolean isWaved() {
        return BitUtil.isSet((int)this.myStyle, (int)8);
    }

    public boolean isUnderline() {
        return BitUtil.isSet((int)this.myStyle, (int)16);
    }

    public boolean isBoldDottedLine() {
        return BitUtil.isSet((int)this.myStyle, (int)32);
    }

    public boolean isSearchMatch() {
        return BitUtil.isSet((int)this.myStyle, (int)64);
    }

    public boolean isSmaller() {
        return BitUtil.isSet((int)this.myStyle, (int)128);
    }

    public boolean isOpaque() {
        return BitUtil.isSet((int)this.myStyle, (int)256);
    }

    @NotNull
    public static SimpleTextAttributes fromTextAttributes(TextAttributes attributes) {
        if (attributes == null) {
            return REGULAR_ATTRIBUTES;
        }
        Color foregroundColor = attributes.getForegroundColor();
        if (foregroundColor == null) {
            foregroundColor = REGULAR_ATTRIBUTES.getFgColor();
        }
        int style = attributes.getFontType();
        if (attributes.getEffectColor() != null) {
            EffectType effectType = attributes.getEffectType();
            if (effectType == EffectType.STRIKEOUT) {
                style |= 4;
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                style |= 8;
            } else if (effectType == EffectType.LINE_UNDERSCORE || effectType == EffectType.BOLD_LINE_UNDERSCORE || effectType == EffectType.BOLD_DOTTED_LINE) {
                style |= 0x10;
            } else if (effectType == EffectType.SEARCH_MATCH) {
                style |= 0x40;
            }
        }
        return new SimpleTextAttributes(attributes.getBackgroundColor(), foregroundColor, attributes.getEffectColor(), style);
    }

    @JdkConstants.FontStyle
    public int getFontStyle() {
        return this.myStyle & 3;
    }

    public TextAttributes toTextAttributes() {
        EffectType effectType;
        Color effectColor;
        if (this.isWaved()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.WAVE_UNDERSCORE;
        } else if (this.isStrikeout()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.STRIKEOUT;
        } else if (this.isUnderline()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.LINE_UNDERSCORE;
        } else if (this.isBoldDottedLine()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.BOLD_DOTTED_LINE;
        } else if (this.isSearchMatch()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.SEARCH_MATCH;
        } else {
            effectColor = null;
            effectType = null;
        }
        return new TextAttributes(this.myFgColor, null, effectColor, effectType, this.myStyle & 3);
    }

    public SimpleTextAttributes derive(@StyleAttributeConstant int style, @Nullable Color fg, @Nullable Color bg, @Nullable Color wave) {
        return new SimpleTextAttributes(bg != null ? bg : this.getBgColor(), fg != null ? fg : this.getFgColor(), wave != null ? wave : this.getWaveColor(), style == -1 ? this.getStyle() : style);
    }

    public static SimpleTextAttributes merge(SimpleTextAttributes weak, SimpleTextAttributes strong) {
        int style = strong.getStyle() | weak.getStyle();
        Color wave = !Comparing.equal((Object)strong.getWaveColor(), (Object)REGULAR_ATTRIBUTES.getWaveColor()) ? strong.getWaveColor() : weak.getWaveColor();
        Color fg = !Comparing.equal((Object)strong.getFgColor(), (Object)REGULAR_ATTRIBUTES.getFgColor()) ? strong.getFgColor() : weak.getFgColor();
        Color bg = !Comparing.equal((Object)strong.getBgColor(), (Object)REGULAR_ATTRIBUTES.getBgColor()) ? strong.getBgColor() : weak.getBgColor();
        return new SimpleTextAttributes(bg, fg, wave, style);
    }

    public static @interface StyleAttributeConstant {
    }
}

