/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.FinelyAdjustable;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class Adjuster
implements FinelyAdjustable {
    private final Consumer<Integer> myConsumer;
    private double myFractionalRemainder;

    public Adjuster(@NotNull Consumer<Integer> consumer) {
        this.myConsumer = consumer;
    }

    @Override
    public void adjustValue(double delta) {
        if (delta == 0.0) {
            return;
        }
        if (Math.signum(this.myFractionalRemainder) != Math.signum(delta)) {
            this.myFractionalRemainder = 0.0;
        }
        double compoundDelta = this.myFractionalRemainder + delta;
        int integralDelta = (int)compoundDelta;
        this.myFractionalRemainder = compoundDelta - (double)integralDelta;
        if (integralDelta != 0) {
            this.myConsumer.consume((Object)integralDelta);
        }
    }

    public void reset() {
        this.myFractionalRemainder = 0.0;
    }
}

