/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionLink
extends LinkLabel
implements DataProvider {
    private static final EmptyIcon ICON = (EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)0, (int)12));
    private final AnAction myAction;
    private String myPlace = "unknown";
    private InputEvent myEvent;
    private Color myVisitedColor;
    private Color myActiveColor;
    private Color myNormalColor;

    public ActionLink(String text, @NotNull AnAction action) {
        this(text, (Icon)ICON, action);
    }

    public ActionLink(String text, Icon icon, @NotNull AnAction action) {
        this(text, icon, action, null);
    }

    public ActionLink(String text, Icon icon, @NotNull AnAction action, final @Nullable Runnable onDone) {
        super(text, icon);
        this.setListener(new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                Presentation presentation = ActionLink.this.myAction.getTemplatePresentation().clone();
                AnActionEvent event = new AnActionEvent(ActionLink.this.myEvent, DataManager.getInstance().getDataContext(ActionLink.this), ActionLink.this.myPlace, presentation, ActionManager.getInstance(), 0);
                ActionUtil.performDumbAwareUpdate(false, ActionLink.this.myAction, event, true);
                if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
                    ActionLink.this.myAction.actionPerformed(event);
                    if (onDone != null) {
                        onDone.run();
                    }
                }
            }
        }, null);
        this.myAction = action;
    }

    @Override
    public void doClick(InputEvent e) {
        this.myEvent = e;
        super.doClick();
    }

    public AnAction getAction() {
        return this.myAction;
    }

    @Override
    protected Color getVisited() {
        return this.myVisitedColor == null ? super.getVisited() : this.myVisitedColor;
    }

    public Color getActiveColor() {
        return this.myActiveColor == null ? super.getActive() : this.myActiveColor;
    }

    @Override
    protected Color getTextColor() {
        return this.myUnderline ? this.getActiveColor() : this.getNormal();
    }

    @Override
    protected Color getNormal() {
        return this.myNormalColor == null ? super.getNormal() : this.myNormalColor;
    }

    public void setVisitedColor(Color visitedColor) {
        this.myVisitedColor = visitedColor;
    }

    public void setActiveColor(Color activeColor) {
        this.myActiveColor = activeColor;
    }

    public void setNormalColor(Color normalColor) {
        this.myNormalColor = normalColor;
    }

    @Override
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
            Point p = SwingUtilities.getRoot(this).getLocationOnScreen();
            return new Rectangle(p.x, p.y + this.getHeight(), 0, 0);
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            return SwingUtilities.convertPoint(this, 0, this.getHeight(), UIUtil.getRootPane((Component)this));
        }
        return null;
    }
}

