/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HintUpdateSupply {
    private static final Key<HintUpdateSupply> HINT_UPDATE_MARKER = Key.create((String)"HINT_UPDATE_MARKER");
    @Nullable
    private JBPopup myHint;

    @Nullable
    public static HintUpdateSupply getSupply(@NotNull JComponent component) {
        return (HintUpdateSupply)component.getClientProperty(HINT_UPDATE_MARKER);
    }

    public static void hideHint(@NotNull JComponent component) {
        HintUpdateSupply supply = HintUpdateSupply.getSupply(component);
        if (supply != null) {
            supply.hideHint();
        }
    }

    public static void installSimpleHintUpdateSupply(@NotNull JComponent component) {
        HintUpdateSupply.installHintUpdateSupply(component, (Function<Object, PsiElement>)((Function)o -> o instanceof PsiElement ? (PsiElement)o : null));
    }

    public static void installDataContextHintUpdateSupply(@NotNull JComponent component) {
        HintUpdateSupply.installHintUpdateSupply(component, (Function<Object, PsiElement>)((Function)o -> o instanceof PsiElement ? (PsiElement)o : CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext(component))));
    }

    public static void installHintUpdateSupply(@NotNull JComponent component, final Function<Object, PsiElement> provider) {
        HintUpdateSupply supply = new HintUpdateSupply(component){

            @Override
            @Nullable
            protected PsiElement getPsiElementForHint(@Nullable Object selectedValue) {
                return (PsiElement)provider.fun(selectedValue);
            }
        };
        if (component instanceof JList) {
            supply.installListListener((JList)component);
        }
        if (component instanceof JTree) {
            supply.installTreeListener((JTree)component);
        }
        if (component instanceof JTable) {
            supply.installTableListener((JTable)component);
        }
    }

    protected HintUpdateSupply(@NotNull JComponent component) {
        this.installSupply(component);
    }

    public HintUpdateSupply(@NotNull JBTable table) {
        this.installSupply(table);
        this.installTableListener(table);
    }

    public HintUpdateSupply(@NotNull Tree tree) {
        this.installSupply(tree);
        this.installTreeListener(tree);
    }

    public HintUpdateSupply(@NotNull JBList list) {
        this.installSupply(list);
        this.installListListener(list);
    }

    protected void installTableListener(final @NotNull JTable table) {
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(table)) {
                    return;
                }
                int selected = ((ListSelectionModel)e.getSource()).getLeadSelectionIndex();
                int rowCount = table.getRowCount();
                if (selected == -1 || rowCount == 0) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(table.getValueAt(Math.min(selected, rowCount - 1), 0));
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        };
        table.getSelectionModel().addListSelectionListener(listener);
        table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    protected void installTreeListener(final @NotNull JTree tree) {
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PsiElement psiElement;
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(tree)) {
                    return;
                }
                TreePath path2 = tree.getSelectionPath();
                if (path2 != null && (psiElement = HintUpdateSupply.this.getPsiElementForHint(path2.getLastPathComponent())) != null && psiElement.isValid()) {
                    HintUpdateSupply.this.updateHint(psiElement);
                }
            }
        });
    }

    protected void installListListener(final @NotNull JList list) {
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(list)) {
                    return;
                }
                Object[] selectedValues = ((JList)e.getSource()).getSelectedValues();
                if (selectedValues.length != 1) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(selectedValues[0]);
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        });
    }

    @Nullable
    protected abstract PsiElement getPsiElementForHint(@Nullable Object var1);

    private void installSupply(@NotNull JComponent component) {
        component.putClientProperty(HINT_UPDATE_MARKER, this);
    }

    public void registerHint(JBPopup hint) {
        this.hideHint();
        this.myHint = hint;
    }

    public void hideHint() {
        if (HintUpdateSupply.isHintVisible(this.myHint)) {
            this.myHint.cancel();
        }
        this.myHint = null;
    }

    public void updateHint(PsiElement element) {
        if (!HintUpdateSupply.isHintVisible(this.myHint)) {
            return;
        }
        PopupUpdateProcessorBase updateProcessor = this.myHint.getUserData(PopupUpdateProcessorBase.class);
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    @Contract(value="!null->true")
    private static boolean isHintVisible(JBPopup hint) {
        return hint != null && hint.isVisible();
    }

    private static boolean isSelectedByMouse(@NotNull JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty("byMouseEvent"));
    }
}

