/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.text.Matcher;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedSearch
extends SpeedSearchSupply {
    private static final String ALLOWED_SPECIAL_SYMBOLS = " *_-\"'/.$>:";
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private String myString = "";
    private boolean myEnabled;
    private Matcher myMatcher;

    public void type(String letter) {
        this.updatePattern(this.myString + letter);
    }

    public void backspace() {
        if (this.myString.length() > 0) {
            this.updatePattern(this.myString.substring(0, this.myString.length() - 1));
        }
    }

    public boolean shouldBeShowing(String string) {
        return string == null || this.myString.length() == 0 || this.myMatcher != null && this.myMatcher.matches(string);
    }

    public void process(KeyEvent e) {
        String old = this.myString;
        if (e.isConsumed()) {
            return;
        }
        if (e.getKeyCode() == 8) {
            this.backspace();
            e.consume();
        } else if (e.getKeyCode() == 27) {
            if (this.isHoldingFilter()) {
                this.updatePattern("");
                e.consume();
            }
        } else {
            char ch = e.getKeyChar();
            if (Character.isLetterOrDigit(ch) || ALLOWED_SPECIAL_SYMBOLS.indexOf(ch) != -1) {
                this.type(Character.toString(ch));
                e.consume();
            }
        }
        if (!old.equalsIgnoreCase(this.myString)) {
            this.update();
        }
    }

    public void update() {
    }

    public void noHits() {
    }

    public boolean isHoldingFilter() {
        return this.myEnabled && this.myString.length() > 0;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void reset() {
        if (this.isHoldingFilter()) {
            this.updatePattern("");
        }
        if (this.myEnabled) {
            this.update();
        }
    }

    public String getFilter() {
        return this.myString;
    }

    public void updatePattern(String string) {
        String prevString = this.myString;
        this.myString = string;
        try {
            this.myMatcher = NameUtil.buildMatcher((String)("*" + string), (int)0, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            this.myMatcher = null;
        }
        this.fireStateChanged(prevString);
    }

    @Nullable
    public Matcher getMatcher() {
        return this.myMatcher;
    }

    @Override
    @Nullable
    public Iterable<TextRange> matchingFragments(@NotNull String text) {
        if (this.myMatcher instanceof MinusculeMatcher) {
            return ((MinusculeMatcher)this.myMatcher).matchingFragments(text);
        }
        return null;
    }

    @Override
    public void refreshSelection() {
    }

    @Override
    public boolean isPopupActive() {
        return this.isHoldingFilter();
    }

    @Override
    @Nullable
    public String getEnteredPrefix() {
        return this.myString;
    }

    @Override
    public void addChangeListener(@NotNull PropertyChangeListener listener) {
        this.myChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removeChangeListener(@NotNull PropertyChangeListener listener) {
        this.myChangeSupport.removePropertyChangeListener(listener);
    }

    private void fireStateChanged(String prevString) {
        this.myChangeSupport.firePropertyChange("enteredPrefix", prevString, this.getEnteredPrefix());
    }

    @Override
    public void findAndSelectElement(@NotNull String searchQuery) {
    }
}

