/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTree
extends Tree
implements CellEditorListener {
    private static final SimpleNode NULL_NODE = new NullNode();
    private static final int INVALID = -1;
    private ActionGroup myPopupGroup;
    private String myPlace;
    private JComponent myEditorComponent;
    private boolean myEscapePressed;
    private int myEditingRow;
    private boolean myIgnoreSelectionChange;
    private int myMinHeightInRows = 5;
    private Icon myExpandedHandle;
    private Icon myCollapsedHandle;
    private Icon myEmptyHandle;

    public SimpleTree() {
        this.setModel(new DefaultTreeModel(new PatchedDefaultMutableTreeNode()));
        TreeUtil.installActions(this);
        this.configureUiHelper(TreeUIHelper.getInstance());
        this.addMouseListener(new MyMouseListener());
        this.setCellRenderer(new NodeRenderer());
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!SimpleTree.this.myIgnoreSelectionChange && SimpleTree.this.hasSingleSelection()) {
                    SimpleTree.this.getNodeFor(SimpleTree.this.getSelectionPath()).handleSelection(SimpleTree.this);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SimpleTree.this.hasSingleSelection()) {
                    SimpleTree.this.handleDoubleClickOrEnter(SimpleTree.this.getSelectionPath(), e);
                }
                if (e.getKeyCode() == 113 && e.getModifiers() == 0) {
                    e.consume();
                }
            }
        });
        UIUtil.setLineStyleAngled((JTree)this);
        if (SystemInfo.isWindows && !SystemInfo.isWinVistaOrNewer) {
            this.setUI(new BasicTreeUI());
        }
        this.setOpaque(UIUtil.isUnderGTKLookAndFeel());
    }

    public SimpleTree(TreeModel aModel) {
        this();
        this.setModel(aModel);
    }

    protected void configureUiHelper(TreeUIHelper helper) {
        helper.installTreeSpeedSearch(this);
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    public boolean accept(AbstractTreeBuilder builder, final SimpleNodeVisitor visitor) {
        return builder.accept(SimpleNode.class, new TreeVisitor<SimpleNode>(){

            @Override
            public boolean visit(@NotNull SimpleNode node) {
                return visitor.accept(node);
            }
        }) != null;
    }

    public void setPopupGroup(ActionGroup aPopupGroup, String aPlace) {
        this.myPopupGroup = aPopupGroup;
        this.myPlace = aPlace;
    }

    public SimpleNode getNodeFor(int row) {
        return this.getNodeFor(this.getPathForRow(row));
    }

    public SimpleNode getNodeFor(TreePath aPath) {
        if (aPath == null) {
            return NULL_NODE;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)aPath.getLastPathComponent();
        if (treeNode == null) {
            return NULL_NODE;
        }
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof SimpleNode) {
            return (SimpleNode)userObject;
        }
        return NULL_NODE;
    }

    @Nullable
    public TreePath getPathFor(SimpleNode node) {
        DefaultMutableTreeNode nodeWithObject = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.getModel().getRoot(), node);
        if (nodeWithObject != null) {
            return TreeUtil.getPathFromRoot(nodeWithObject);
        }
        return null;
    }

    @Nullable
    public SimpleNode getSelectedNode() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        return this.getNodeFor(this.getSelectionPath());
    }

    @Override
    public boolean isSelectionEmpty() {
        TreePath selection = super.getSelectionPath();
        return selection == null || this.getNodeFor(selection) == NULL_NODE;
    }

    public SimpleNode[] getSelectedNodesIfUniform() {
        ArrayList<SimpleNode> result = new ArrayList<SimpleNode>();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            Object lastNode = null;
            for (TreePath selectionPath : selectionPaths) {
                SimpleNode nodeFor = this.getNodeFor(selectionPath);
                if (lastNode != null && lastNode.getClass() != nodeFor.getClass()) {
                    return new SimpleNode[0];
                }
                result.add(nodeFor);
                lastNode = nodeFor;
            }
        }
        return result.toArray(new SimpleNode[result.size()]);
    }

    public void setSelectedNode(AbstractTreeBuilder builder, SimpleNode node, boolean expand) {
        builder.select(node.getElement(), null, false);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        g.setColor(UIManager.getColor("Tree.line"));
        for (int row = 0; row < this.getRowCount(); ++row) {
            TreePath path2 = this.getPathForRow(row);
            if (!this.getNodeFor(path2).shouldHaveSeparator()) continue;
            Rectangle bounds = this.getRowBounds(row);
            int x = (int)bounds.getMaxX();
            int y = (int)(bounds.getY() + (double)(bounds.height / 2));
            g.drawLine(x, y, this.getWidth() - 5, y);
        }
    }

    public void doClick(int row) {
        this.setSelectionRow(row);
    }

    @Override
    public void cancelEditing() {
        if (this.isEditing()) {
            this.cellEditor.cancelCellEditing();
            this.doStopEditing();
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.doStopEditing();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.doStopEditing();
    }

    public JComponent getEditorComponent() {
        return this.myEditorComponent;
    }

    @Override
    public boolean isEditing() {
        return this.myEditorComponent != null;
    }

    @Override
    public TreePath getEditingPath() {
        if (this.isEditing()) {
            return this.getPathForRow(this.myEditingRow);
        }
        return super.getEditingPath();
    }

    @Override
    public boolean isPathEditable(TreePath path2) {
        return true;
    }

    @Override
    public final boolean isFileColorsEnabled() {
        return false;
    }

    @Override
    protected boolean paintNodes() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEditing()) {
            Rectangle editedNodeRect = this.getRowBounds(this.myEditingRow);
            if (editedNodeRect == null) {
                return;
            }
            g.setColor(this.getBackground());
            g.fillRect(editedNodeRect.x, editedNodeRect.y, editedNodeRect.width, editedNodeRect.height);
        }
    }

    @Override
    public void setCellEditor(TreeCellEditor aCellEditor) {
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(this);
        }
        super.setCellEditor(aCellEditor);
        if (this.cellEditor != null) {
            this.cellEditor.addCellEditorListener(this);
        }
    }

    @Override
    public boolean stopEditing() {
        boolean result = this.isEditing();
        if (result) {
            if (!this.cellEditor.stopCellEditing()) {
                this.cellEditor.cancelCellEditing();
            }
            this.doStopEditing();
        }
        return result;
    }

    @Override
    public void startEditingAtPath(TreePath path2) {
        if (path2 != null && this.isVisible(path2)) {
            if (this.isEditing() && !this.stopEditing()) {
                return;
            }
            this.startEditing(path2);
        }
    }

    private void startEditing(TreePath path2) {
        TreeCellEditor editor = this.getCellEditor();
        if (editor != null && editor.isCellEditable(null) && this.isPathEditable(path2)) {
            this.getSelectionModel().clearSelection();
            this.getSelectionModel().setSelectionPath(path2);
            this.myEditingRow = this.getRowForPath(path2);
            this.myEditorComponent = (JComponent)this.getCellEditor().getTreeCellEditorComponent(this, path2.getLastPathComponent(), this.isPathSelected(path2), this.isExpanded(path2), this.treeModel.isLeaf(path2.getLastPathComponent()), this.myEditingRow);
            this.putEditor(path2);
            if (this.myEditorComponent.isFocusable()) {
                this.myEditorComponent.requestFocusInWindow();
            }
            SwingUtilities.invokeLater(() -> this.scrollPathToVisible(path2));
        }
    }

    private void putEditor(TreePath path2) {
        this.add(this.myEditorComponent);
        Rectangle nodeBounds = this.getPathBounds(path2);
        Dimension editorPrefSize = this.myEditorComponent.getPreferredSize();
        if (editorPrefSize.height > nodeBounds.height) {
            nodeBounds.y -= (editorPrefSize.height - nodeBounds.height) / 2;
            nodeBounds.height = editorPrefSize.height;
        }
        this.myEditorComponent.setBounds(nodeBounds);
        this.myEscapePressed = false;
    }

    private void doStopEditing() {
        if (this.isEditing()) {
            this.remove(this.myEditorComponent);
            this.myEditorComponent = null;
            this.setSelectionRow(this.myEditingRow);
            this.myEditingRow = -1;
            this.repaint();
        }
    }

    public boolean isEscapePressed() {
        return this.myEscapePressed;
    }

    public void setEscapePressed() {
        this.myEscapePressed = true;
    }

    @Override
    public void addSelectionPath(TreePath path2) {
        this.myIgnoreSelectionChange = true;
        super.addSelectionPath(path2);
        this.myIgnoreSelectionChange = false;
    }

    @Override
    public void addSelectionPaths(TreePath[] path2) {
        this.myIgnoreSelectionChange = true;
        super.addSelectionPaths(path2);
        this.myIgnoreSelectionChange = false;
    }

    private boolean isSelected(TreePath path2) {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                if (!path2.equals(selectionPath)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMultipleSelection() {
        return this.getSelectionRows() != null && this.getSelectionRows().length > 1;
    }

    private void handleDoubleClickOrEnter(TreePath treePath, InputEvent e) {
        Runnable runnable = () -> this.getNodeFor(treePath).handleDoubleClickOrEnter(this, e);
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent(this));
    }

    public static boolean isDoubleClick(MouseEvent e) {
        return e != null && e.getClickCount() > 0 && e.getClickCount() % 2 == 0;
    }

    protected ActionGroup getPopupGroup() {
        return this.myPopupGroup;
    }

    protected void invokeContextMenu(MouseEvent e) {
        SwingUtilities.invokeLater(() -> {
            ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu(this.myPlace, this.myPopupGroup);
            menu.getComponent().show(e.getComponent(), e.getPoint().x, e.getPoint().y);
        });
    }

    public boolean select(AbstractTreeBuilder aBuilder, final SimpleNodeVisitor aVisitor, boolean shouldExpand) {
        return aBuilder.select(SimpleNode.class, new TreeVisitor<SimpleNode>(){

            @Override
            public boolean visit(@NotNull SimpleNode node) {
                return aVisitor.accept(node);
            }
        }, null, false);
    }

    private void debugTree(AbstractTreeBuilder aBuilder) {
        TreeUtil.traverseDepth((TreeNode)aBuilder.getTree().getModel().getRoot(), node -> {
            System.out.println("Node: " + node);
            return true;
        });
    }

    private boolean hasSingleSelection() {
        return !this.isSelectionEmpty() && this.getSelectionPaths().length == 1;
    }

    public DefaultTreeModel getBuilderModel() {
        return (DefaultTreeModel)this.getModel();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return super.getPreferredSize();
    }

    public NodeRenderer getRenderer() {
        return (NodeRenderer)this.getCellRenderer();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '#' + System.identityHashCode(this);
    }

    public final void setMinSizeInRows(int rows) {
        this.myMinHeightInRows = rows;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension superSize = super.getMinimumSize();
        if (this.myMinHeightInRows == -1) {
            return superSize;
        }
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return superSize;
        }
        double rowHeight = this.getRowBounds(0).getHeight();
        return new Dimension(superSize.width, (int)(rowHeight * (double)this.myMinHeightInRows));
    }

    @Override
    public final int getToggleClickCount() {
        SimpleNode node = this.getSelectedNode();
        if (node != null && !node.expandOnDoubleClick()) {
            return -1;
        }
        return super.getToggleClickCount();
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    private int getBoxWidth(TreePath path2) {
        TreePath parent;
        Object root = this.getModel().getRoot();
        if (!this.isRootVisible() && path2.getPathCount() == 2 && (parent = path2.getParentPath()).getLastPathComponent() == root && !this.getShowsRootHandles()) {
            return 0;
        }
        return SimpleTree.getBoxWidth(this);
    }

    private static int getBoxWidth(JTree tree) {
        BasicTreeUI basicTreeUI = (BasicTreeUI)tree.getUI();
        int boxWidth = basicTreeUI.getExpandedIcon() != null ? basicTreeUI.getExpandedIcon().getIconWidth() : 8;
        return boxWidth;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.myExpandedHandle = null;
        this.myCollapsedHandle = null;
        this.myExpandedHandle = null;
    }

    public Icon getHandleIcon(DefaultMutableTreeNode node, TreePath path2) {
        if (node.getChildCount() == 0) {
            return this.getEmptyHandle();
        }
        return this.isExpanded(path2) ? this.getExpandedHandle() : this.getCollapsedHandle();
    }

    public Icon getExpandedHandle() {
        if (this.myExpandedHandle == null) {
            this.myExpandedHandle = UIUtil.getTreeExpandedIcon();
        }
        return this.myExpandedHandle;
    }

    public Icon getCollapsedHandle() {
        if (this.myCollapsedHandle == null) {
            this.myCollapsedHandle = UIUtil.getTreeCollapsedIcon();
        }
        return this.myCollapsedHandle;
    }

    public Icon getEmptyHandle() {
        if (this.myEmptyHandle == null) {
            Icon expand = this.getExpandedHandle();
            this.myEmptyHandle = expand != null ? EmptyIcon.create((Icon)expand) : EmptyIcon.create((int)0);
        }
        return this.myEmptyHandle;
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.invokePopup(e);
            } else if (SimpleTree.isDoubleClick(e)) {
                SimpleTree.this.handleDoubleClickOrEnter(SimpleTree.this.getClosestPathForLocation(e.getX(), e.getY()), e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.invokePopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.invokePopup(e);
        }

        private void invokePopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.insideTreeItemsArea(e)) {
                this.selectPathUnderCursorIfNeeded(e);
                if (SimpleTree.this.myPopupGroup != null) {
                    SimpleTree.this.invokeContextMenu(e);
                }
            }
        }

        private void selectPathUnderCursorIfNeeded(MouseEvent e) {
            TreePath pathForLocation = SimpleTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (!SimpleTree.this.isSelected(pathForLocation)) {
                SimpleTree.this.setSelectionPath(pathForLocation);
            }
        }

        private boolean insideTreeItemsArea(MouseEvent e) {
            Rectangle rowBounds = SimpleTree.this.getRowBounds(SimpleTree.this.getRowCount() - 1);
            if (rowBounds == null) {
                return false;
            }
            double lastItemBottomLine = rowBounds.getMaxY();
            return (double)e.getY() <= lastItemBottomLine;
        }
    }
}

