/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageViewPresentation;
import org.jetbrains.annotations.NotNull;

public class UsageLimitUtil {
    public static final int USAGES_LIMIT = 1000;

    public static void showAndCancelIfAborted(@NotNull Project project, @NotNull String message, @NotNull UsageViewPresentation usageViewPresentation) {
        Result retCode = UsageLimitUtil.showTooManyUsagesWarning(project, message, usageViewPresentation);
        if (retCode != Result.CONTINUE) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    public static Result showTooManyUsagesWarning(@NotNull Project project, @NotNull String message, @NotNull UsageViewPresentation usageViewPresentation) {
        int result = UsageLimitUtil.runOrInvokeAndWait((Computable<Integer>)((Computable)() -> {
            String title = UsageViewBundle.message("find.excessive.usages.title", StringUtil.capitalize((String)StringUtil.pluralize((String)usageViewPresentation.getUsagesWord())));
            return Messages.showOkCancelDialog(project, message, title, UsageViewBundle.message("button.text.continue", new Object[0]), UsageViewBundle.message("button.text.abort", new Object[0]), Messages.getWarningIcon());
        }));
        return result == 0 ? Result.CONTINUE : Result.ABORT;
    }

    private static int runOrInvokeAndWait(@NotNull Computable<Integer> f) {
        int[] answer = new int[1];
        try {
            GuiUtils.runOrInvokeAndWait(() -> {
                answer[0] = (Integer)f.compute();
            });
        }
        catch (Exception e) {
            answer[0] = 0;
        }
        return answer[0];
    }

    public static enum Result {
        CONTINUE,
        ABORT;

    }
}

