/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final int myRuleIndex;
    private int myRecursiveUsageCount;
    private final List<Node> myChildren = new SmartList();

    GroupNode(Node parent, @Nullable UsageGroup group, int ruleIndex) {
        this.setUserObject(group);
        this.setParent(parent);
        this.myRuleIndex = ruleIndex;
    }

    @Override
    protected void updateNotify() {
        if (this.getGroup() != null) {
            this.getGroup().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String result = this.getGroup() == null ? "" : this.getGroup().getText(null);
        GroupNode groupNode = this;
        synchronized (groupNode) {
            List<Node> children = this.myChildren;
            return result + children.subList(0, Math.min(10, children.size()));
        }
    }

    @NotNull
    List<Node> getChildren() {
        return this.myChildren;
    }

    @NotNull
    List<Node> getSwingChildren() {
        return (List)ObjectUtils.notNull((Object)this.children, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    GroupNode addOrGetGroup(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<Node> edtInsertedUnderQueue) {
        GroupNode newNode = new GroupNode(this, group, ruleIndex);
        GroupNode groupNode = this;
        synchronized (groupNode) {
            int insertionIndex = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (insertionIndex >= 0) {
                return (GroupNode)this.myChildren.get(insertionIndex);
            }
            int i2 = -insertionIndex - 1;
            this.myChildren.add(i2, newNode);
        }
        edtInsertedUnderQueue.consume((Object)this);
        return newNode;
    }

    private static int getNodeIndex(@NotNull Node newNode, @NotNull List<Node> children) {
        int low = 0;
        int high = children.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            Node child = children.get(mid);
            int cmp = COMPARATOR.compare(child, newNode);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int getNodeInsertionIndex(@NotNull Node node, @NotNull List<Node> children) {
        int i2 = GroupNode.getNodeIndex(node, children);
        return i2 >= 0 ? i2 : -i2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTargetsNode(@NotNull Node node, @NotNull DefaultTreeModel treeModel) {
        int index;
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            index = GroupNode.getNodeInsertionIndex(node, this.getSwingChildren());
            this.myChildren.add(index, node);
        }
        treeModel.insertNodeInto(node, this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.removeAllChildren();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            this.myChildren.clear();
        }
        this.myRecursiveUsageCount = 0;
    }

    @Nullable
    private UsageNode tryMerge(@NotNull Usage usage) {
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.getUsageNodes()) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    void removeUsage(@NotNull UsageNode usage, @NotNull DefaultTreeModel treeModel) {
        this.removeUsagesBulk(Collections.singleton(usage), treeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUsagesBulk(@NotNull Set<UsageNode> usages, @NotNull DefaultTreeModel treeModel) {
        boolean removed;
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            removed = this.myChildren.removeAll(usages);
            if (!removed) {
                for (GroupNode groupNode2 : this.getSubGroups()) {
                    if (!groupNode2.removeUsagesBulk(usages, treeModel)) continue;
                    if (groupNode2.getRecursiveUsageCount() == 0) {
                        treeModel.removeNodeFromParent(groupNode2);
                        this.myChildren.remove(groupNode2);
                    }
                    removed = true;
                    break;
                }
            }
        }
        if (removed) {
            this.wasRemoved(treeModel);
        }
        return removed;
    }

    private void wasRemoved(@NotNull DefaultTreeModel treeModel) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        --this.myRecursiveUsageCount;
        treeModel.nodeChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    UsageNode addUsage(@NotNull Usage usage, @NotNull Consumer<Node> edtInsertedUnderQueue, boolean filterDuplicateLines) {
        UsageNode newNode;
        GroupNode groupNode = this;
        synchronized (groupNode) {
            UsageNode mergedWith;
            if (filterDuplicateLines && (mergedWith = this.tryMerge(usage)) != null) {
                return mergedWith;
            }
            newNode = new UsageNode(this, usage);
            int index = GroupNode.getNodeInsertionIndex(newNode, this.myChildren);
            this.myChildren.add(index, newNode);
        }
        edtInsertedUnderQueue.consume((Object)this);
        return newNode;
    }

    void incrementUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        while (true) {
            ++groupNode.myRecursiveUsageCount;
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        if (this.getGroup() != null) {
            result.append(this.getGroup());
        }
        result.append("[");
        result.append(lineSeparator);
        for (Node node : this.myChildren) {
            result.append(node.tree2string(indent + 4, lineSeparator));
            result.append(lineSeparator);
        }
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        result.append("]");
        result.append(lineSeparator);
        return result.toString();
    }

    @Override
    protected boolean isDataValid() {
        return this.getGroup() == null || this.getGroup().isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof Node) || !((Node)element).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull GroupNode groupNode) {
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.getGroup().compareTo(groupNode.getGroup());
        }
        return Integer.compare(this.myRuleIndex, groupNode.myRuleIndex);
    }

    public synchronized UsageGroup getGroup() {
        return (UsageGroup)this.getUserObject();
    }

    int getRecursiveUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myRecursiveUsageCount;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.getGroup() != null) {
            this.getGroup().navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.getGroup() != null && this.getGroup().canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.getGroup() != null && this.getGroup().canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        for (Node node : this.myChildren) {
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getText(@NotNull UsageView view) {
        return this.getGroup().getText(view);
    }

    @NotNull
    public synchronized Collection<GroupNode> getSubGroups() {
        ArrayList<GroupNode> list = new ArrayList<GroupNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof GroupNode)) continue;
            list.add((GroupNode)n);
        }
        return list;
    }

    @NotNull
    public synchronized Collection<UsageNode> getUsageNodes() {
        ArrayList<UsageNode> list = new ArrayList<UsageNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof UsageNode)) continue;
            list.add((UsageNode)n);
        }
        return list;
    }

    private static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparator() {
        }

        private static ClassIndex getClassIndex(DefaultMutableTreeNode node) {
            if (node instanceof UsageNode) {
                return ClassIndex.USAGE;
            }
            if (node instanceof GroupNode) {
                return ClassIndex.GROUP;
            }
            if (node instanceof UsageTargetNode) {
                return ClassIndex.USAGE_TARGET;
            }
            return ClassIndex.UNKNOWN;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            ClassIndex classIdx2;
            ClassIndex classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1.compareTo(classIdx2);
            }
            if (classIdx1 == ClassIndex.GROUP) {
                return ((GroupNode)n1).compareTo((GroupNode)n2);
            }
            if (classIdx1 == ClassIndex.USAGE) {
                return ((UsageNode)n1).compareTo((UsageNode)n2);
            }
            return 0;
        }

        static enum ClassIndex {
            UNKNOWN,
            USAGE_TARGET,
            GROUP,
            USAGE;

        }
    }
}

