/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private boolean myIsProcessing;

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        ArrayList result = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        this.forEach(processor);
        return result;
    }

    @Override
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator(this.findAll().iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<Result>)processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (!this.myIsProcessing) : "Operation is not allowed while query is being processed";
    }

    @Override
    @NotNull
    public Result[] toArray(@NotNull Result[] a) {
        this.assertNotProcessing();
        Collection<Result> all2 = this.findAll();
        return all2.toArray(a);
    }

    @Override
    public boolean forEach(@NotNull Processor<Result> consumer) {
        this.assertNotProcessing();
        this.myIsProcessing = true;
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing = false;
        }
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<Result> consumer) {
        return AsyncUtil.wrapBoolean(this.forEach(consumer));
    }

    protected abstract boolean processResults(@NotNull Processor<Result> var1);

    @NotNull
    protected AsyncFuture<Boolean> processResultsAsync(@NotNull Processor<Result> consumer) {
        return AsyncUtil.wrapBoolean(this.processResults(consumer));
    }

    @NotNull
    public static <T> Query<T> wrapInReadAction(final @NotNull Query<T> query) {
        return new AbstractQuery<T>(){

            @Override
            protected boolean processResults(@NotNull Processor<T> consumer) {
                return query.forEach(ReadActionProcessor.wrapInReadAction(consumer));
            }
        };
    }
}

