/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ContentsUtil {
    protected static final String DISPOSABLE_KEY = "TabContentDisposable";

    public static void addOrReplaceContent(ContentManager manager, Content content, boolean select) {
        String contentName = content.getDisplayName();
        Content[] contents = manager.getContents();
        Content oldContentFound = null;
        for (Content oldContent : contents) {
            if (oldContent.isPinned() || !oldContent.getDisplayName().equals(contentName)) continue;
            oldContentFound = oldContent;
            break;
        }
        manager.addContent(content);
        if (oldContentFound != null) {
            manager.removeContent(oldContentFound, true);
        }
        if (select) {
            manager.setSelectedContent(content);
        }
    }

    public static void addContent(ContentManager manager, Content content, boolean select) {
        manager.addContent(content);
        if (select) {
            manager.setSelectedContent(content);
        }
    }

    public static void closeContentTab(@NotNull ContentManager contentManager, @NotNull Content content) {
        TabbedContent tabbedContent;
        if (content instanceof TabbedContent && (tabbedContent = (TabbedContent)content).getTabs().size() > 1) {
            JComponent component = tabbedContent.getComponent();
            tabbedContent.removeContent(component);
            contentManager.setSelectedContent(tabbedContent, true, true);
            ContentsUtil.dispose(component);
            return;
        }
        contentManager.removeContent(content, true);
    }

    private static void dispose(@NotNull JComponent component) {
        Object disposable = component.getClientProperty(DISPOSABLE_KEY);
        if (disposable instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)disposable));
        }
    }
}

