/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.util.Condition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class FilteredQuery<T>
implements Query<T> {
    private final Query<T> myOriginal;
    private final Condition<T> myFilter;

    public FilteredQuery(@NotNull Query<T> original, @NotNull Condition<T> filter) {
        this.myOriginal = original;
        this.myFilter = filter;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return (T)processor.getFoundValue();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        this.myOriginal.forEach(new MyProcessor(consumer));
        return true;
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<T> consumer) {
        return this.myOriginal.forEachAsync(new MyProcessor(consumer));
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList result = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        this.forEach((Processor<T>)processor);
        return result;
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }

    private class MyProcessor
    implements Processor<T> {
        private final Processor<T> myConsumer;

        public MyProcessor(Processor<T> consumer) {
            this.myConsumer = consumer;
        }

        public boolean process(T t) {
            return !FilteredQuery.this.myFilter.value(t) || this.myConsumer.process(t);
        }
    }
}

