/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.FileIconKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create((String)"iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = key -> {
        VirtualFile file = key.getFile();
        int flags = key.getFlags();
        Project project = key.getProject();
        if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
            return null;
        }
        Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
        Object icon = providersIcon == null ? VirtualFilePresentation.getIconImpl(file) : providersIcon;
        boolean dumb = project != null && DumbService.getInstance(project).isDumb();
        for (FileIconPatcher patcher : IconUtil.getPatchers()) {
            if (dumb && !DumbService.isDumbAware(patcher)) continue;
            icon = patcher.patchIcon((Icon)icon, file, flags & 0xFFFFFFFD, project);
        }
        if (file.is(VFileProperty.SYMLINK)) {
            icon = new LayeredIcon(new Icon[]{icon, PlatformIcons.SYMLINK_ICON});
        }
        if (!(!BitUtil.isSet((int)flags, (int)2) || file.isWritable() && WritingAccessProvider.isPotentiallyWritable(file, project))) {
            icon = new LayeredIcon(new Icon[]{icon, PlatformIcons.LOCKED_ICON});
        }
        Iconable.LastComputedIcon.put((UserDataHolder)file, icon, flags);
        return icon;
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        Boolean was = (Boolean)project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, was);
            } else {
                was = false;
            }
        }
        return was;
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, int maxWidth, int maxHeight) {
        if (icon.getIconHeight() <= maxHeight && icon.getIconWidth() <= maxWidth) {
            return icon;
        }
        int w = Math.min(icon.getIconWidth(), maxWidth);
        int h = Math.min(icon.getIconHeight(), maxHeight);
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(new JPanel(), g, 0, 0);
        g.dispose();
        BufferedImage img = UIUtil.createImage((Graphics)g, (int)w, (int)h, (int)3);
        int offX = icon.getIconWidth() > maxWidth ? (icon.getIconWidth() - maxWidth) / 2 : 0;
        int offY = icon.getIconHeight() > maxHeight ? (icon.getIconHeight() - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, image.getRGB(col + offX, row + offY));
            }
        }
        return new ImageIcon(img);
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, @NotNull Rectangle area) {
        if (!new Rectangle(icon.getIconWidth(), icon.getIconHeight()).contains(area)) {
            return icon;
        }
        return new CropIcon(icon, area);
    }

    @NotNull
    public static Icon flip(final @NotNull Icon icon, final boolean horizontal) {
        return new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    AffineTransform transform = AffineTransform.getTranslateInstance(horizontal ? (double)(x + this.getIconWidth()) : (double)x, horizontal ? (double)y : (double)(y + this.getIconHeight()));
                    transform.concatenate(AffineTransform.getScaleInstance(horizontal ? -1.0 : 1.0, horizontal ? 1.0 : -1.0));
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    icon.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        };
    }

    public static Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        Icon lastIcon = Iconable.LastComputedIcon.get((UserDataHolder)file, flags);
        Icon base = lastIcon != null ? lastIcon : VirtualFilePresentation.getIconImpl(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), ICON_NULLABLE_FUNCTION);
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, Project project) {
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/class.png"), 0);
        if (showVisibility) {
            baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/c_public.png"), 1);
        }
        return baseIcon;
    }

    @NotNull
    private static Icon createEmptyIconLike(@NotNull String baseIconPath) {
        Icon baseIcon = IconLoader.findIcon((String)baseIconPath);
        if (baseIcon == null) {
            return EmptyIcon.ICON_16;
        }
        return EmptyIcon.create((Icon)baseIcon);
    }

    private static FileIconProvider[] getProviders() {
        return FileIconProviderHolder.myProviders;
    }

    private static FileIconPatcher[] getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    public static Image toImage(@NotNull Icon icon) {
        return IconLoader.toImage((Icon)icon);
    }

    @NotNull
    public static Icon getAddIcon() {
        return IconUtil.getToolbarDecoratorIcon("add.png");
    }

    @NotNull
    public static Icon getRemoveIcon() {
        return IconUtil.getToolbarDecoratorIcon("remove.png");
    }

    @NotNull
    public static Icon getMoveUpIcon() {
        return IconUtil.getToolbarDecoratorIcon("moveUp.png");
    }

    @NotNull
    public static Icon getMoveDownIcon() {
        return IconUtil.getToolbarDecoratorIcon("moveDown.png");
    }

    @NotNull
    public static Icon getEditIcon() {
        return IconUtil.getToolbarDecoratorIcon("edit.png");
    }

    @NotNull
    public static Icon getAddClassIcon() {
        return IconUtil.getToolbarDecoratorIcon("addClass.png");
    }

    @NotNull
    public static Icon getAddPatternIcon() {
        return IconUtil.getToolbarDecoratorIcon("addPattern.png");
    }

    @NotNull
    public static Icon getAddJiraPatternIcon() {
        return IconUtil.getToolbarDecoratorIcon("addJira.png");
    }

    @NotNull
    public static Icon getAddYouTrackPatternIcon() {
        return IconUtil.getToolbarDecoratorIcon("addYouTrack.png");
    }

    @NotNull
    public static Icon getAddBlankLineIcon() {
        return IconUtil.getToolbarDecoratorIcon("addBlankLine.png");
    }

    @NotNull
    public static Icon getAddPackageIcon() {
        return IconUtil.getToolbarDecoratorIcon("addPackage.png");
    }

    @NotNull
    public static Icon getAddLinkIcon() {
        return IconUtil.getToolbarDecoratorIcon("addLink.png");
    }

    @NotNull
    public static Icon getAddFolderIcon() {
        return IconUtil.getToolbarDecoratorIcon("addFolder.png");
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        return IconUtil.getToolbarDecoratorIcon("analyze.png");
    }

    public static void paintInCenterOf(@NotNull Component c, @NotNull Graphics g, @NotNull Icon icon) {
        int x = (c.getWidth() - icon.getIconWidth()) / 2;
        int y = (c.getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(c, g, x, y);
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name) {
        return IconLoader.getIcon((String)(IconUtil.getToolbarDecoratorIconsFolder() + name));
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        return "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
    }

    @NotNull
    public static Icon[] getEqualSizedIcons(Icon ... icons) {
        Icon[] result = new Icon[icons.length];
        int width = 0;
        int height = 0;
        for (Icon icon : icons) {
            width = Math.max(width, icon.getIconWidth());
            height = Math.max(height, icon.getIconHeight());
        }
        for (int i2 = 0; i2 < icons.length; ++i2) {
            result[i2] = new IconSizeWrapper(icons[i2], width, height);
        }
        return result;
    }

    @NotNull
    public static Icon toSize(@Nullable Icon icon, int width, int height) {
        return new IconSizeWrapper(icon, width, height);
    }

    @NotNull
    public static Icon scale(final @NotNull Icon source, double _scale) {
        Image image;
        final int hiDPIscale = source instanceof ImageIcon ? (RetinaImage.isAppleHiDPIScaledImage((Image)(image = ((ImageIcon)source).getImage())) || image instanceof JBHiDPIScaledImage ? 2 : 1) : 1;
        final double scale = Math.min(32.0, Math.max(0.1, _scale));
        return new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.translate(x, y);
                    AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    source.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return (int)((double)source.getIconWidth() * scale) / hiDPIscale;
            }

            @Override
            public int getIconHeight() {
                return (int)((double)source.getIconHeight() * scale) / hiDPIscale;
            }
        };
    }

    @NotNull
    public static Icon scale(@NotNull Icon icon, float scale, boolean smartScale) {
        if (smartScale && icon instanceof ScalableIcon) {
            return ((ScalableIcon)icon).scale(scale);
        }
        return IconUtil.scale(icon, scale);
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color) {
        return IconUtil.colorize(source, color, false);
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        return IconUtil.colorize(g, source, color, false);
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color, boolean keepGray) {
        return IconUtil.filterIcon(null, source, new ColorFilter(color, keepGray));
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color, boolean keepGray) {
        return IconUtil.filterIcon(g, source, new ColorFilter(color, keepGray));
    }

    @NotNull
    public static Icon desaturate(@NotNull Icon source) {
        return IconUtil.filterIcon(null, source, new DesaturationFilter());
    }

    @NotNull
    public static Icon brighter(@NotNull Icon source, int tones) {
        return IconUtil.filterIcon(null, source, new BrighterFilter(tones));
    }

    @NotNull
    public static Icon darker(@NotNull Icon source, int tones) {
        return IconUtil.filterIcon(null, source, new DarkerFilter(tones));
    }

    @NotNull
    private static Icon filterIcon(Graphics2D g, @NotNull Icon source, @NotNull Filter filter) {
        BufferedImage src = g != null ? UIUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)3) : UIUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)3);
        Graphics2D g2d = src.createGraphics();
        source.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        BufferedImage img = g != null ? UIUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)3) : UIUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)3);
        int[] rgba = new int[4];
        for (int y = 0; y < src.getRaster().getHeight(); ++y) {
            for (int x = 0; x < src.getRaster().getWidth(); ++x) {
                src.getRaster().getPixel(x, y, rgba);
                if (rgba[3] == 0) continue;
                img.getRaster().setPixel(x, y, filter.convert(rgba));
            }
        }
        return IconUtil.createImageIcon(img);
    }

    @NotNull
    public static JBImageIcon createImageIcon(@NotNull BufferedImage img) {
        return new JBImageIcon(img){

            public int getIconWidth() {
                return this.getImage() instanceof JBHiDPIScaledImage ? super.getIconWidth() / 2 : super.getIconWidth();
            }

            public int getIconHeight() {
                return this.getImage() instanceof JBHiDPIScaledImage ? super.getIconHeight() / 2 : super.getIconHeight();
            }
        };
    }

    @NotNull
    public static Icon textToIcon(@NotNull String text, @NotNull Component component, float fontSize) {
        JBFont font = JBFont.create((Font)JBUI.Fonts.label().deriveFont(fontSize));
        FontMetrics metrics = component.getFontMetrics((Font)font);
        int width = metrics.stringWidth(text) + JBUI.scale((int)4);
        int height = metrics.getHeight();
        return new Icon((Font)font, text, height, width){
            final /* synthetic */ Font val$font;
            final /* synthetic */ String val$text;
            final /* synthetic */ int val$height;
            final /* synthetic */ int val$width;
            {
                this.val$font = font;
                this.val$text = string;
                this.val$height = n;
                this.val$width = n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                try {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    g.setFont(this.val$font);
                    UIUtil.drawStringWithHighlighting((Graphics)g, (String)this.val$text, (int)(x + JBUI.scale((int)2)), (int)(y + this.val$height - JBUI.scale((int)1)), (Color)JBColor.foreground(), (Color)JBColor.background());
                }
                finally {
                    g.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return this.val$width;
            }

            @Override
            public int getIconHeight() {
                return this.val$height;
            }
        };
    }

    @NotNull
    public static Icon addText(@NotNull Icon base, @NotNull String text) {
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        icon.setIcon(IconUtil.textToIcon(text, new JLabel(), JBUI.scale((float)6.0f)), 1, 4);
        return icon;
    }

    private static class DarkerFilter
    extends Filter {
        private final int myTones;

        public DarkerFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            float[] hsb = Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], null);
            float brightness = hsb[2];
            for (int i2 = 0; i2 < this.myTones && (brightness = Math.max(0.0f, brightness / 1.1f)) != 0.0f; ++i2) {
            }
            Color color = Color.getHSBColor(hsb[0], hsb[1], brightness);
            return new int[]{color.getRed(), color.getGreen(), color.getBlue(), rgba[3]};
        }
    }

    private static class BrighterFilter
    extends Filter {
        private final int myTones;

        public BrighterFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            float[] hsb = Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], null);
            float brightness = hsb[2];
            for (int i2 = 0; i2 < this.myTones && (brightness = Math.min(1.0f, brightness * 1.1f)) != 1.0f; ++i2) {
            }
            Color color = Color.getHSBColor(hsb[0], hsb[1], brightness);
            return new int[]{color.getRed(), color.getGreen(), color.getBlue(), rgba[3]};
        }
    }

    private static class DesaturationFilter
    extends Filter {
        private DesaturationFilter() {
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            int min = Math.min(Math.min(rgba[0], rgba[1]), rgba[2]);
            int max = Math.max(Math.max(rgba[0], rgba[1]), rgba[2]);
            int grey = (max + min) / 2;
            return new int[]{grey, grey, grey, rgba[3]};
        }
    }

    private static class ColorFilter
    extends Filter {
        private final float[] myBase;
        private final boolean myKeepGray;

        private ColorFilter(@NotNull Color color, boolean keepGray) {
            this.myKeepGray = keepGray;
            this.myBase = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], hsb);
            int rgb = Color.HSBtoRGB(this.myBase[0], this.myBase[1] * (this.myKeepGray ? hsb[1] : 1.0f), this.myBase[2] * hsb[2]);
            return new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgba[3]};
        }
    }

    private static abstract class Filter {
        private Filter() {
        }

        @NotNull
        abstract int[] convert(@NotNull int[] var1);
    }

    private static class CropIcon
    implements Icon {
        private final Icon mySrc;
        private final Rectangle myCrop;

        private CropIcon(@NotNull Icon src, @NotNull Rectangle crop) {
            this.mySrc = src;
            this.myCrop = crop;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.mySrc.paintIcon(c, g, x - this.myCrop.x, y - this.myCrop.y);
        }

        @Override
        public int getIconWidth() {
            return this.myCrop.width;
        }

        @Override
        public int getIconHeight() {
            return this.myCrop.height;
        }
    }

    public static class IconSizeWrapper
    implements Icon {
        private final Icon myIcon;
        private final int myWidth;
        private final int myHeight;

        protected IconSizeWrapper(@Nullable Icon icon, int width, int height) {
            this.myIcon = icon;
            this.myWidth = width;
            this.myHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintIcon(this.myIcon, c, g, x, y);
        }

        protected void paintIcon(@Nullable Icon icon, Component c, Graphics g, int x, int y) {
            if (icon == null) {
                return;
            }
            icon.paintIcon(c, g, x += (this.myWidth - icon.getIconWidth()) / 2, y += (this.myHeight - icon.getIconHeight()) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = (FileIconPatcher[])Extensions.getExtensions(FileIconPatcher.EP_NAME);

        private FileIconPatcherHolder() {
        }
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = (FileIconProvider[])Extensions.getExtensions(FileIconProvider.EP_NAME);

        private FileIconProviderHolder() {
        }
    }
}

