/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtil {
    private PathUtil() {
    }

    @Nullable
    public static String getLocalPath(@Nullable VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem().getProtocol().equals("jar") && file.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file.getPath());
    }

    @NotNull
    public static String getLocalPath(@NotNull String path2) {
        return FileUtil.toSystemDependentName((String)StringUtil.trimEnd((String)path2, (String)"!/"));
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile file) {
        VirtualFile localFile;
        if (!file.isValid()) {
            return file;
        }
        if (file.getFileSystem() instanceof LocalFileProvider && (localFile = ((LocalFileProvider)((Object)file.getFileSystem())).getLocalVirtualFileFor(file)) != null) {
            return localFile;
        }
        return file;
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class aClass) {
        String pathForClass = PathManager.getJarPathForClass((Class)aClass);
        assert (pathForClass != null) : aClass;
        return pathForClass;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        return PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
    }

    public static String getCanonicalPath(@NonNls String path2) {
        return FileUtil.toCanonicalPath((String)path2);
    }

    @NotNull
    public static String getFileName(@NotNull String path2) {
        return PathUtilRt.getFileName((String)path2);
    }

    @Nullable
    public static String getFileExtension(@NotNull String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    @NotNull
    public static String getParentPath(@NotNull String path2) {
        return PathUtilRt.getParentPath((String)path2);
    }

    @NotNull
    public static String suggestFileName(@NotNull String text) {
        return PathUtilRt.suggestFileName((String)text);
    }

    @NotNull
    public static String suggestFileName(@NotNull String text, boolean allowDots, boolean allowSpaces) {
        return PathUtilRt.suggestFileName((String)text, (boolean)allowDots, (boolean)allowSpaces);
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        return PathUtilRt.isValidFileName((String)fileName, (boolean)true);
    }

    public static boolean isValidFileName(@NotNull String fileName, boolean strict) {
        return PathUtilRt.isValidFileName((String)fileName, (boolean)strict);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemIndependentName(@Nullable String path2) {
        return path2 == null ? null : FileUtilRt.toSystemIndependentName((String)path2);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemDependentName(@Nullable String path2) {
        return path2 == null ? null : FileUtilRt.toSystemDependentName((String)path2);
    }

    @NotNull
    public static String driveLetterToLowerCase(@NotNull String path2) {
        File file;
        if (SystemInfo.isWindows && path2.length() >= 2 && Character.isUpperCase(path2.charAt(0)) && path2.charAt(1) == ':' && (file = new File(path2)).isAbsolute()) {
            return Character.toLowerCase(path2.charAt(0)) + path2.substring(1);
        }
        return path2;
    }

    @NotNull
    public static String makeFileName(@NotNull String name, @Nullable String extension) {
        return StringUtil.isEmpty((String)extension) ? name : name + '.' + extension;
    }
}

