/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class SingletonInstancesCache {
    private static final ConcurrentMap<String, Object> CACHE = ContainerUtil.newConcurrentMap();

    private SingletonInstancesCache() {
    }

    public static <T> T getInstance(@NotNull String className, ClassLoader classLoader) {
        Object res = CACHE.get(className);
        if (res == null) {
            try {
                res = classLoader.loadClass(className).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object oldValue = CACHE.putIfAbsent(className, res);
            if (oldValue != null) {
                res = oldValue;
            }
        }
        return (T)res;
    }
}

