/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SmartList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.IntProperty;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.StorageProperty;
import com.intellij.util.config.StringProperty;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExternalizablePropertyContainer
extends AbstractProperty.AbstractPropertyContainer {
    private static final Logger LOG = Logger.getInstance(ExternalizablePropertyContainer.class);
    private final Map<AbstractProperty, Object> myValues = new THashMap();
    private final Map<AbstractProperty, Externalizer> myExternalizers = new THashMap();

    public <T> void registerProperty(AbstractProperty<T> property, Externalizer<T> externalizer) {
        String name = property.getName();
        LOG.assertTrue(!this.myExternalizers.containsKey(property), (Object)name);
        this.myExternalizers.put(property, externalizer);
    }

    public void rememberKey(AbstractProperty property) {
        LOG.assertTrue(this.myExternalizers.get(property) == null, (Object)property.getName());
        this.myExternalizers.put(property, null);
    }

    public void registerProperty(BooleanProperty property) {
        this.registerProperty(property, Externalizer.BOOLEAN);
    }

    public void registerProperty(StringProperty property) {
        this.registerProperty(property, Externalizer.STRING);
    }

    public void registerProperty(IntProperty property) {
        this.registerProperty(property, Externalizer.INTEGER);
    }

    public void registerProperty(StorageProperty property) {
        this.registerProperty(property, Externalizer.STORAGE);
    }

    public <T> void registerProperty(ListProperty<T> property, @NonNls String itemTagName, Externalizer<T> itemExternalizer) {
        this.registerProperty(property, ExternalizablePropertyContainer.createListExternalizer(itemExternalizer, itemTagName));
    }

    public <T extends JDOMExternalizable> void registerProperty(ListProperty<T> property, @NonNls String itemTagName, Factory<T> factory) {
        this.registerProperty(property, itemTagName, Externalizer.FactoryBased.create(factory));
    }

    private static <T> Externalizer<List<T>> createListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
        return new ListExternalizer<T>(itemExternalizer, itemTagName);
    }

    public void readExternal(@NotNull Element element) {
        THashMap propertyByName = new THashMap();
        for (AbstractProperty abstractProperty : this.myExternalizers.keySet()) {
            propertyByName.put(abstractProperty.getName(), abstractProperty);
        }
        for (Element child : element.getChildren()) {
            Externalizer externalizer;
            AbstractProperty property = (AbstractProperty)propertyByName.get(child.getName());
            if (property == null || (externalizer = this.myExternalizers.get(property)) == null) continue;
            try {
                this.myValues.put(property, externalizer.readValue(child));
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (this.myExternalizers.isEmpty()) {
            return;
        }
        ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>(this.myExternalizers.keySet());
        Collections.sort(properties, AbstractProperty.NAME_COMPARATOR);
        for (AbstractProperty property : properties) {
            Object propValue;
            Externalizer externalizer = this.myExternalizers.get(property);
            if (externalizer == null || Comparing.equal(propValue = property.get(this), property.getDefault(this))) continue;
            Element child = new Element(property.getName());
            externalizer.writeValue(child, propValue);
            if (JDOMUtil.isEmpty((Element)child)) continue;
            element.addContent(child);
        }
    }

    protected Object getValueOf(AbstractProperty property) {
        Object value = this.myValues.get(property);
        return value != null ? value : property.getDefault(this);
    }

    protected void setValueOf(AbstractProperty externalizableProperty, Object value) {
        this.myValues.put(externalizableProperty, value);
    }

    @Override
    public boolean hasProperty(AbstractProperty property) {
        return this.myExternalizers.containsKey(property);
    }

    private static class ListExternalizer<T>
    implements Externalizer<List<T>> {
        @NonNls
        private static final String NULL_ELEMENT = "NULL_VALUE_ELEMENT";
        private final Externalizer<T> myItemExternalizer;
        private final String myItemTagName;

        public ListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
            this.myItemExternalizer = itemExternalizer;
            this.myItemTagName = itemTagName;
        }

        @Override
        public List<T> readValue(Element dataElement) {
            SmartList list = new SmartList();
            for (Element element : dataElement.getChildren()) {
                if (NULL_ELEMENT.equals(element.getName())) {
                    list.add(null);
                    continue;
                }
                if (!this.myItemTagName.equals(element.getName())) continue;
                T item = this.myItemExternalizer.readValue(element);
                if (item == null) {
                    LOG.error("Can't create element " + this.myItemExternalizer);
                    return list;
                }
                list.add(item);
            }
            return list;
        }

        @Override
        public void writeValue(Element dataElement, List<T> value) {
            for (T item : value) {
                if (item == null) {
                    dataElement.addContent(new Element(NULL_ELEMENT));
                    continue;
                }
                Element element = new Element(this.myItemTagName);
                this.myItemExternalizer.writeValue(element, item);
                dataElement.addContent(element);
            }
        }
    }
}

