/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBasedIndex
implements BaseComponent {
    public static final boolean ourEnableTracingOfKeyHashToVirtualFileMapping = SystemProperties.getBooleanProperty((String)"idea.enable.tracing.keyhash2virtualfile", (boolean)true);

    public abstract void iterateIndexableFiles(@NotNull ContentIterator var1, @NotNull Project var2, ProgressIndicator var3);

    public void iterateIndexableFilesConcurrently(@NotNull ContentIterator processor, @NotNull Project project, ProgressIndicator indicator) {
        this.iterateIndexableFiles(processor, project, indicator);
    }

    public abstract void registerIndexableSet(@NotNull IndexableFileSet var1, @Nullable Project var2);

    public abstract void removeIndexableSet(@NotNull IndexableFileSet var1);

    public static FileBasedIndex getInstance() {
        return ApplicationManager.getApplication().getComponent(FileBasedIndex.class);
    }

    public static int getFileId(@NotNull VirtualFile file) {
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)((Object)file)).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file + ", implementation class: " + file.getClass().getName());
    }

    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(@NotNull ID<?, ?> indexId) {
        this.requestRebuild(indexId, new Throwable());
    }

    @Override
    @NonNls
    @NotNull
    public String getComponentName() {
        return "FileBasedIndex";
    }

    @NotNull
    public abstract <K, V> List<V> getValues(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(@NotNull ID<K, V> var1, @NotNull K var2, @Nullable VirtualFile var3, @NotNull ValueProcessor<V> var4, @NotNull GlobalSearchScope var5);

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull ValueProcessor<V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        return this.processValues(indexId, dataKey, inFile, processor, filter);
    }

    public abstract <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> var1, @NotNull Collection<K> var2, @NotNull GlobalSearchScope var3, @Nullable Condition<V> var4, @NotNull Processor<VirtualFile> var5);

    @NotNull
    public abstract <K> Collection<K> getAllKeys(@NotNull ID<K, ?> var1, @NotNull Project var2);

    public abstract <K> void ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3);

    public abstract void requestRebuild(@NotNull ID<?, ?> var1, Throwable var2);

    public abstract <K> void scheduleRebuild(@NotNull ID<K, ?> var1, @NotNull Throwable var2);

    public abstract void requestReindex(@NotNull VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(@NotNull ID<K, V> var1, @NotNull Set<K> var2, @NotNull Processor<VirtualFile> var3, @NotNull GlobalSearchScope var4);

    public abstract <K> boolean processAllKeys(@NotNull ID<K, ?> var1, @NotNull Processor<K> var2, @Nullable Project var3);

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        return this.processAllKeys(indexId, processor, scope.getProject());
    }

    public static void iterateRecursively(final @Nullable VirtualFile root, final @NotNull ContentIterator processor, final @Nullable ProgressIndicator indicator, final @Nullable Set<VirtualFile> visitedRoots, final @Nullable ProjectFileIndex projectFileIndex) {
        if (root == null) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (visitedRoots != null && !root.equals(file) && file.isDirectory() && !visitedRoots.add(file)) {
                    return false;
                }
                if (projectFileIndex != null && projectFileIndex.isExcluded(file)) {
                    return false;
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                processor.processFile(file);
                return true;
            }
        });
    }

    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> var1);
    }

    @FunctionalInterface
    public static interface InputFilter {
        public boolean acceptInput(@NotNull VirtualFile var1);
    }

    @FunctionalInterface
    public static interface ValueProcessor<V> {
        public boolean process(@NotNull VirtualFile var1, V var2);
    }
}

