/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;

public class CountingGZIPInputStream
extends GZIPInputStream {
    private final CountingInputStream myInputStream;

    private CountingGZIPInputStream(@NotNull CountingInputStream inputStream) throws IOException {
        super(inputStream);
        this.myInputStream = inputStream;
    }

    public long getCompressedBytesRead() {
        return this.myInputStream.myBytesRead;
    }

    @NotNull
    public static CountingGZIPInputStream create(@NotNull InputStream inputStream) throws IOException {
        return new CountingGZIPInputStream(new CountingInputStream(inputStream));
    }

    private static class CountingInputStream
    extends InputStream {
        private final InputStream myInputStream;
        private long myBytesRead = 0L;

        public CountingInputStream(@NotNull InputStream inputStream) {
            this.myInputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            int data = this.myInputStream.read();
            ++this.myBytesRead;
            return data;
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            int bytesRead = this.myInputStream.read(b);
            this.myBytesRead += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            int bytesRead = this.myInputStream.read(b, off, len);
            this.myBytesRead += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public long skip(long n) throws IOException {
            long bytesSkipped = this.myInputStream.skip(n);
            this.myBytesRead += bytesSkipped;
            return bytesSkipped;
        }

        @Override
        public int available() throws IOException {
            return this.myInputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.myInputStream.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.myInputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.myInputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.myInputStream.markSupported();
        }
    }
}

