/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.Patches;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.ProgressMonitorInputStream;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private static final Logger LOG = Logger.getInstance(HttpRequests.class);
    private static final int BLOCK_SIZE = 16384;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([^;]+)");

    private HttpRequests() {
    }

    @NotNull
    public static RequestBuilder request(@NotNull String url) {
        return new RequestBuilderImpl(url);
    }

    @NotNull
    public static String createErrorMessage(@NotNull IOException e, @NotNull Request request, boolean includeHeaders) {
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot download '").append(request.getURL()).append("': ").append(e.getMessage());
        try {
            URLConnection connection = request.getConnection();
            if (includeHeaders) {
                builder.append("\n, headers: ").append(connection.getHeaderFields());
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                builder.append("\n, response: ").append(httpConnection.getResponseCode()).append(' ').append(httpConnection.getResponseMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return builder.toString();
    }

    /*
     * Loose catch block
     */
    private static <T> T process(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        LOG.assertTrue(ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"Network shouldn't be accessed in EDT or inside read action");
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null && HttpRequests.shouldOverrideContextClassLoader(contextLoader)) {
            try {
                T t;
                try (URLClassLoader cl = new URLClassLoader(new URL[0], contextLoader);){
                    Thread.currentThread().setContextClassLoader(cl);
                    t = HttpRequests.doProcess(builder, processor);
                }
                return t;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return HttpRequests.doProcess(builder, processor);
    }

    private static boolean shouldOverrideContextClassLoader(ClassLoader contextLoader) {
        if (!Patches.JDK_BUG_ID_8032832) {
            return false;
        }
        if (!UrlClassLoader.isRegisteredAsParallelCapable((ClassLoader)contextLoader)) {
            return true;
        }
        return SystemProperties.getBooleanProperty((String)"http.requests.override.context.classloader", (boolean)true);
    }

    private static <T> T doProcess(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        CertificateManager manager = ApplicationManager.getApplication() != null ? CertificateManager.getInstance() : null;
        try (RequestImpl request = new RequestImpl(builder);){
            if (manager != null) {
                Object t = manager.runWithUntrustedCertificateStrategy(() -> processor.process(request), builder.myUntrustedCertificateStrategy);
                return t;
            }
            T t = processor.process(request);
            return t;
        }
    }

    private static Charset getCharset(Request request) throws IOException {
        Matcher m;
        String contentType = request.getConnection().getContentType();
        if (!StringUtil.isEmptyOrSpaces((String)contentType) && (m = CHARSET_PATTERN.matcher(contentType)).find()) {
            try {
                return Charset.forName(StringUtil.unquoteString((String)m.group(1)));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("unknown charset (" + contentType + ")", e);
            }
        }
        return CharsetToolkit.UTF8_CHARSET;
    }

    private static URLConnection openConnection(RequestBuilderImpl builder, RequestImpl request) throws IOException {
        String url = request.myUrl;
        for (int i2 = 0; i2 < builder.myRedirectLimit; ++i2) {
            URLConnection connection;
            block18: {
                if (builder.myForceHttps && StringUtil.startsWith((CharSequence)url, (CharSequence)"http:")) {
                    url = "https:" + url.substring(5);
                    request.myUrl = url;
                }
                if ((connection = !builder.myUseProxy ? new URL(url).openConnection(Proxy.NO_PROXY) : (ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url))) instanceof HttpsURLConnection) {
                    if (ApplicationManager.getApplication() != null) {
                        try {
                            SSLContext context = CertificateManager.getInstance().getSslContext();
                            SSLSocketFactory factory = context.getSocketFactory();
                            if (factory != null) {
                                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
                                break block18;
                            }
                            LOG.info("SSLSocketFactory is not defined by IDE CertificateManager; Using default SSL configuration to connect to " + url);
                        }
                        catch (Throwable e) {
                            LOG.info("Problems configuring SSL connection to " + url, e);
                        }
                    } else {
                        LOG.info("Application is not initialized yet; Using default SSL configuration to connect to " + url);
                    }
                }
            }
            connection.setConnectTimeout(builder.myConnectTimeout);
            connection.setReadTimeout(builder.myTimeout);
            if (builder.myUserAgent != null) {
                connection.setRequestProperty("User-Agent", builder.myUserAgent);
            }
            if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
            }
            if (builder.myGzip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            if (builder.myAccept != null) {
                connection.setRequestProperty("Accept", builder.myAccept);
            }
            connection.setUseCaches(false);
            if (builder.myTuner != null) {
                builder.myTuner.tune(connection);
            }
            if (connection instanceof HttpURLConnection) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connecting to " + url);
                }
                int responseCode = ((HttpURLConnection)connection).getResponseCode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response: " + responseCode);
                }
                if (responseCode < 200 || responseCode >= 300 && responseCode != 304) {
                    ((HttpURLConnection)connection).disconnect();
                    if (responseCode == 301 || responseCode == 302) {
                        url = connection.getHeaderField("Location");
                        request.myUrl = url;
                        if (url != null) continue;
                    }
                    String message = IdeBundle.message("error.connection.failed.with.http.code.N", responseCode);
                    throw new HttpStatusException(message, responseCode, StringUtil.notNullize((String)url, (String)"Empty URL"));
                }
            }
            return connection;
        }
        throw new IOException(IdeBundle.message("error.connection.failed.redirects", new Object[0]));
    }

    private static class RequestImpl
    implements Request,
    AutoCloseable {
        private final RequestBuilderImpl myBuilder;
        private String myUrl;
        private URLConnection myConnection;
        private InputStream myInputStream;
        private BufferedReader myReader;

        private RequestImpl(RequestBuilderImpl builder) {
            this.myBuilder = builder;
            this.myUrl = this.myBuilder.myUrl;
        }

        @Override
        @NotNull
        public String getURL() {
            return this.myUrl;
        }

        @Override
        @NotNull
        public URLConnection getConnection() throws IOException {
            if (this.myConnection == null) {
                this.myConnection = HttpRequests.openConnection(this.myBuilder, this);
            }
            return this.myConnection;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            if (this.myInputStream == null) {
                this.myInputStream = this.getConnection().getInputStream();
                if (this.myBuilder.myGzip && "gzip".equalsIgnoreCase(this.getConnection().getContentEncoding())) {
                    this.myInputStream = CountingGZIPInputStream.create(this.myInputStream);
                }
            }
            return this.myInputStream;
        }

        @Override
        @NotNull
        public BufferedReader getReader() throws IOException {
            return this.getReader(null);
        }

        @Override
        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator indicator) throws IOException {
            if (this.myReader == null) {
                int contentLength;
                InputStream inputStream = this.getInputStream();
                if (indicator != null && (contentLength = this.getConnection().getContentLength()) > 0) {
                    inputStream = new ProgressMonitorInputStream(indicator, inputStream, contentLength);
                }
                this.myReader = new BufferedReader(new InputStreamReader(inputStream, HttpRequests.getCharset(this)));
            }
            return this.myReader;
        }

        @Override
        public boolean isSuccessful() throws IOException {
            URLConnection connection = this.getConnection();
            return !(connection instanceof HttpURLConnection) || ((HttpURLConnection)connection).getResponseCode() == 200;
        }

        @Override
        @NotNull
        public byte[] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
            int contentLength = this.getConnection().getContentLength();
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
            NetUtils.copyStreamContent(indicator, this.getInputStream(), (OutputStream)out, contentLength);
            return ArrayUtil.realloc((byte[])out.getInternalBuffer(), (int)out.size());
        }

        @Override
        @NotNull
        public String readString(@Nullable ProgressIndicator indicator) throws IOException {
            Charset cs = HttpRequests.getCharset(this);
            byte[] bytes = this.readBytes(indicator);
            return new String(bytes, cs);
        }

        @Override
        @NotNull
        public File saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
            FileUtilRt.createParentDirs((File)file);
            boolean deleteFile = true;
            try (FileOutputStream out = new FileOutputStream(file);){
                NetUtils.copyStreamContent(indicator, this.getInputStream(), out, this.getConnection().getContentLength());
                deleteFile = false;
            }
            catch (IOException e) {
                throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
            }
            finally {
                if (deleteFile) {
                    FileUtilRt.delete((File)file);
                }
            }
            return file;
        }

        @Override
        public void close() {
            StreamUtil.closeStream((Closeable)this.myInputStream);
            StreamUtil.closeStream((Closeable)this.myReader);
            if (this.myConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.myConnection).disconnect();
            }
        }
    }

    private static class RequestBuilderImpl
    extends RequestBuilder {
        private final String myUrl;
        private int myConnectTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
        private int myTimeout = HttpConfigurable.READ_TIMEOUT;
        private int myRedirectLimit = HttpConfigurable.REDIRECT_LIMIT;
        private boolean myGzip = true;
        private boolean myForceHttps;
        private boolean myUseProxy = true;
        private HostnameVerifier myHostnameVerifier;
        private String myUserAgent;
        private String myAccept;
        private ConnectionTuner myTuner;
        private UntrustedCertificateStrategy myUntrustedCertificateStrategy = UntrustedCertificateStrategy.ASK_USER;

        private RequestBuilderImpl(@NotNull String url) {
            this.myUrl = url;
        }

        @Override
        public RequestBuilder connectTimeout(int value) {
            this.myConnectTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder readTimeout(int value) {
            this.myTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder redirectLimit(int redirectLimit) {
            this.myRedirectLimit = redirectLimit;
            return this;
        }

        @Override
        public RequestBuilder gzip(boolean value) {
            this.myGzip = value;
            return this;
        }

        @Override
        public RequestBuilder forceHttps(boolean forceHttps) {
            this.myForceHttps = forceHttps;
            return this;
        }

        @Override
        public RequestBuilder useProxy(boolean useProxy) {
            this.myUseProxy = useProxy;
            return this;
        }

        @Override
        public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            this.myHostnameVerifier = hostnameVerifier;
            return this;
        }

        @Override
        public RequestBuilder userAgent(@Nullable String userAgent) {
            this.myUserAgent = userAgent;
            return this;
        }

        @Override
        public RequestBuilder productNameAsUserAgent() {
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                ApplicationInfo info = ApplicationInfo.getInstance();
                return this.userAgent(info.getVersionName() + '/' + info.getBuild().asStringWithoutProductCode());
            }
            return this.userAgent("IntelliJ");
        }

        @Override
        public RequestBuilder accept(@Nullable String mimeType) {
            this.myAccept = mimeType;
            return this;
        }

        @Override
        public RequestBuilder tuner(@Nullable ConnectionTuner tuner) {
            this.myTuner = tuner;
            return this;
        }

        @Override
        public RequestBuilder untrustedCertificateStrategy(@NotNull UntrustedCertificateStrategy strategy) {
            this.myUntrustedCertificateStrategy = strategy;
            return this;
        }

        @Override
        public <T> T connect(@NotNull RequestProcessor<T> processor) throws IOException {
            return (T)HttpRequests.process(this, processor);
        }
    }

    public static class HttpStatusException
    extends IOException {
        private int myStatusCode;
        private String myUrl;

        public HttpStatusException(@NotNull String message, int statusCode, @NotNull String url) {
            super(message);
            this.myStatusCode = statusCode;
            this.myUrl = url;
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @NotNull
        public String getUrl() {
            return this.myUrl;
        }

        @Override
        public String getMessage() {
            return "Status: " + this.myStatusCode;
        }

        @Override
        public String toString() {
            return super.toString() + ". Status=" + this.myStatusCode + ", Url=" + this.myUrl;
        }
    }

    public static interface ConnectionTuner {
        public void tune(@NotNull URLConnection var1) throws IOException;
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public String getURL();

        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;

        @NotNull
        public BufferedReader getReader() throws IOException;

        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator var1) throws IOException;

        public boolean isSuccessful() throws IOException;

        @NotNull
        public File saveToFile(@NotNull File var1, @Nullable ProgressIndicator var2) throws IOException;

        @NotNull
        public byte[] readBytes(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        public String readString(@Nullable ProgressIndicator var1) throws IOException;
    }
}

