/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.PathKt$sam$Filter$i$8a553b3f;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0005\u001a\n\u0010\f\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0005\u001a\u0012\u0010\u000f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\n\u0010\u0011\u001a\u00020\u000e*\u00020\u0005\u001a\u0014\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00050\u0005*\u00020\u0005H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u0015*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0015\u001ah\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u00052#\b\b\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00150\u001b2'\u0010\u001f\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00050 \u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(!\u0012\u0004\u0012\u0002H\u00190\u001bH\u0086\b\u00a2\u0006\u0002\u0010\"\u001aC\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u00052'\u0010\u001f\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00050 \u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(!\u0012\u0004\u0012\u0002H\u00190\u001bH\u0086\b\u00a2\u0006\u0002\u0010#\u001a\n\u0010$\u001a\u00020\u0015*\u00020\u0005\u001a\n\u0010%\u001a\u00020&*\u00020\u0005\u001a\f\u0010'\u001a\u0004\u0018\u00010&*\u00020\u0005\u001a\n\u0010(\u001a\u00020\u0015*\u00020\u0005\u001a\n\u0010\u0017\u001a\u00020\u0015*\u00020\u0005\u001a\n\u0010)\u001a\u00020\u0015*\u00020\u0005\u001a\n\u0010*\u001a\u00020+*\u00020\u0005\u001a\u0012\u0010,\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\n\u0010-\u001a\u00020.*\u00020\u0005\u001a\n\u0010/\u001a\u000200*\u00020\u0005\u001a\n\u00101\u001a\u000202*\u00020\u0005\u001a\n\u00103\u001a\u00020\u0004*\u00020\u0005\u001a\n\u00104\u001a\u000205*\u00020\u0005\u001a\n\u00106\u001a\u000205*\u00020\u0005\u001a&\u00107\u001a\u00020\u0005*\u00020\u00052\u0006\u00108\u001a\u0002002\b\b\u0002\u00109\u001a\u00020:2\b\b\u0002\u00104\u001a\u00020:\u001a\u0012\u00107\u001a\u00020\u0005*\u00020\u00052\u0006\u00108\u001a\u00020\u0004\u001a\u001a\u0010;\u001a\u00020\u0005*\u00020\u00052\u0006\u0010<\u001a\u00020\u00042\u0006\u00108\u001a\u000200\u001a\u001a\u0010;\u001a\u00020\u0005*\u00020\u00052\u0006\u0010<\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004\u001a\u001e\u0010=\u001a\u00020\u0005*\u00020\u00052\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u000e0\u001b\u001a&\u0010=\u001a\u00020\u0005*\u00020\u00052\u0006\u00108\u001a\u0002002\b\b\u0002\u00109\u001a\u00020:2\b\b\u0002\u00104\u001a\u00020:\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006?"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parentSystemIndependentPath", "", "Ljava/nio/file/Path;", "getParentSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "basicAttributesIfExists", "Ljava/nio/file/attribute/BasicFileAttributes;", "createDirectories", "createFile", "", "createSymbolicLink", "target", "delete", "deleteRecursively", "kotlin.jvm.PlatformType", "deleteWithParentsIfEmpty", "", "root", "isFile", "directoryStreamIfExists", "R", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "path", "task", "Ljava/nio/file/DirectoryStream;", "stream", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exists", "inputStream", "Ljava/io/InputStream;", "inputStreamIfExists", "isDirectory", "isHidden", "lastModified", "Ljava/nio/file/attribute/FileTime;", "move", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readChars", "", "readText", "size", "", "sizeOrNull", "write", "data", "offset", "", "writeChild", "relativePath", "writeSafe", "outConsumer", "projectModel-api"})
public final class PathKt {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.io.FileUtil");

    public static final boolean exists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.exists($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final Path createDirectories(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path2 = Files.createDirectories($receiver, new FileAttribute[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Files.createDirectories(this)");
        return path2;
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        OutputStream outputStream = Files.newOutputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream inputStream = Files.newInputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(this)");
        return inputStream;
    }

    @Nullable
    public static final InputStream inputStreamIfExists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            return PathKt.inputStream($receiver);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @NotNull
    public static final Path createSymbolicLink(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createSymbolicLink($receiver, target, new FileAttribute[0]);
        return $receiver;
    }

    public static final void delete(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($receiver);
        if (basicFileAttributes == null) {
            return;
        }
        BasicFileAttributes attributes = basicFileAttributes;
        try {
            if (attributes.isDirectory()) {
                PathKt.deleteRecursively($receiver);
            } else {
                Files.delete($receiver);
            }
        }
        catch (Exception e) {
            FileUtil.delete((File)$receiver.toFile());
        }
    }

    public static final boolean deleteWithParentsIfEmpty(@NotNull Path $receiver, @NotNull Path root, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        try {
            PathKt.delete($receiver);
        }
        catch (NoSuchFileException e) {
            return false;
        }
        for (Path parent = isFile ? $receiver.getParent() : null; parent != null && Intrinsics.areEqual((Object)parent, (Object)root) ^ true; parent = parent.getParent()) {
            try {
                Files.delete(parent);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean deleteWithParentsIfEmpty$default(Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.deleteWithParentsIfEmpty(path2, path3, bl);
    }

    private static final Path deleteRecursively(@NotNull Path $receiver) {
        return Files.walkFileTree($receiver, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                try {
                    Files.delete(file);
                }
                catch (Exception e) {
                    FileUtil.delete((File)file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                try {
                    Files.delete(dir);
                }
                catch (Exception e) {
                    FileUtil.delete((File)dir.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @NotNull
    public static final FileTime lastModified(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FileTime fileTime = Files.getLastModifiedTime($receiver, new LinkOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTime, (String)"Files.getLastModifiedTime(this)");
        return fileTime;
    }

    @NotNull
    public static final String getSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)((Object)$receiver).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path2 = $receiver.getParent();
        if (path2 == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)((Object)path2).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = Files.readAllBytes($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(this)");
        return byArray;
    }

    @NotNull
    public static final String readText(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = PathKt.readBytes($receiver);
        Charset charset = Charsets.UTF_8;
        return new String(byArray, charset);
    }

    @NotNull
    public static final CharSequence readChars(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream inputStream = PathKt.inputStream($receiver);
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        return IoKt.readCharSequence(new InputStreamReader(inputStream, charset), (int)PathKt.size($receiver));
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return PathKt.write$default($receiver.resolve(relativePath), data, 0, 0, 6, null);
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data;
        Charset charset = null;
        boolean bl = true;
        Object var6_6 = null;
        String string2 = relativePath;
        Path path2 = $receiver;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return PathKt.writeChild(path2, string2, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull byte[] data, int offset, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Closeable closeable = PathKt.outputStream($receiver);
        boolean bl = false;
        try {
            OutputStream it = (OutputStream)closeable;
            it.write(data, offset, size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                Closeable closeable2 = closeable;
                if (closeable2 != null) {
                    closeable2.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                Closeable closeable3 = closeable;
                if (closeable3 != null) {
                    closeable3.close();
                }
            }
        }
        return $receiver;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path write$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.write(path2, byArray, n, n2);
    }

    @NotNull
    public static final Path writeSafe(@NotNull Path $receiver, @NotNull byte[] data, int offset, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path tempFile = $receiver.getParent().resolve($receiver.getFileName() + "." + UUID.randomUUID() + ".tmp");
        PathKt.write(tempFile, data, offset, size);
        try {
            Files.move(tempFile, $receiver, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            FileUtil.rename((File)tempFile.toFile(), (File)$receiver.toFile());
        }
        return $receiver;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path writeSafe$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.writeSafe(path2, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path writeSafe(@NotNull Path $receiver, @NotNull Function1<? super OutputStream, Unit> outConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(outConsumer, (String)"outConsumer");
        Path tempFile = $receiver.getParent().resolve($receiver.getFileName() + "." + UUID.randomUUID() + ".tmp");
        Closeable closeable = PathKt.outputStream(tempFile);
        boolean bl = false;
        try {
            Object object = outConsumer.invoke((Object)closeable);
        }
        catch (Exception exception) {
            bl = true;
            try {
                Closeable closeable2 = closeable;
                if (closeable2 != null) {
                    closeable2.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                Closeable closeable3 = closeable;
                if (closeable3 != null) {
                    closeable3.close();
                }
            }
        }
        try {
            Files.move(tempFile, $receiver, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            FileUtil.rename((File)tempFile.toFile(), (File)$receiver.toFile());
        }
        return $receiver;
    }

    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        String string = data;
        Charset charset = null;
        boolean bl = true;
        Object var5_5 = null;
        Path path3 = $receiver;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        Files.write(path3, byArray2, new OpenOption[0]);
        return $receiver;
    }

    public static final long size(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.size($receiver);
    }

    @Nullable
    public static final BasicFileAttributes basicAttributesIfExists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            return Files.readAttributes($receiver, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException ignored) {
            return null;
        }
    }

    public static final long sizeOrNull(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($receiver);
        return basicFileAttributes != null ? basicFileAttributes.size() : -1L;
    }

    public static final boolean isHidden(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isHidden($receiver);
    }

    public static final boolean isDirectory(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final Path move(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = Files.move($receiver, target, StandardCopyOption.REPLACE_EXISTING);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Files.move(this, target,\u2026yOption.REPLACE_EXISTING)");
        return path2;
    }

    public static final void createFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createFile($receiver, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($receiver);
            boolean bl = false;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super Path, Boolean> filter, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Function1<? super Path, Boolean> function1 = filter;
            Closeable closeable = Files.newDirectoryStream($receiver, (DirectoryStream.Filter)(function1 == null ? null : new PathKt$sam$Filter$i$8a553b3f(function1)));
            boolean bl = false;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }
}

