/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

final class ProgressMonitorInputStream
extends InputStream {
    private final ProgressIndicator indicator;
    private final InputStream in;
    private double available;
    private long count;

    public ProgressMonitorInputStream(@NotNull ProgressIndicator indicator, @NotNull InputStream in, int length) {
        this.indicator = indicator;
        this.in = in;
        this.available = length;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        this.updateProgress(c >= 0 ? 1L : 0L);
        return c;
    }

    private void updateProgress(long increment) {
        this.indicator.checkCanceled();
        if (increment > 0L) {
            this.count += increment;
            this.indicator.setFraction((double)this.count / this.available);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        this.updateProgress(r);
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        this.updateProgress(r);
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.in.skip(n);
        this.updateProgress(r);
        return r;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }
}

