/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RequestBuilder {
    public abstract RequestBuilder connectTimeout(int var1);

    public abstract RequestBuilder readTimeout(int var1);

    public abstract RequestBuilder redirectLimit(int var1);

    public abstract RequestBuilder gzip(boolean var1);

    public abstract RequestBuilder forceHttps(boolean var1);

    public abstract RequestBuilder useProxy(boolean var1);

    public abstract RequestBuilder hostNameVerifier(@Nullable HostnameVerifier var1);

    public abstract RequestBuilder userAgent(@Nullable String var1);

    public abstract RequestBuilder productNameAsUserAgent();

    public abstract RequestBuilder accept(@Nullable String var1);

    public abstract RequestBuilder tuner(@Nullable HttpRequests.ConnectionTuner var1);

    public abstract RequestBuilder untrustedCertificateStrategy(@NotNull UntrustedCertificateStrategy var1);

    public abstract <T> T connect(@NotNull HttpRequests.RequestProcessor<T> var1) throws IOException;

    public int tryConnect() throws IOException {
        return this.connect(request -> {
            URLConnection connection = request.getConnection();
            return connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
        });
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor, T errorValue, @Nullable Logger logger) {
        try {
            return this.connect(processor);
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.warn(e);
            }
            return errorValue;
        }
    }

    public void saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
        this.connect(request -> request.saveToFile(file, indicator));
    }

    @NotNull
    public byte[] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
        return this.connect(request -> request.readBytes(indicator));
    }

    @NotNull
    public String readString(@Nullable ProgressIndicator indicator) throws IOException {
        return this.connect(request -> request.readString(indicator));
    }
}

