/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NSScrollerHelper {
    private static final Callback APPEARANCE_CALLBACK = new Callback(){

        public void callback(ID self, Pointer selector, ID event) {
            UIUtil.invokeLaterIfNeeded(() -> NSScrollerHelper.fireStyleChanged());
        }
    };
    private static final Callback BEHAVIOR_CALLBACK = new Callback(){

        public void callback(ID self, Pointer selector, ID event) {
            UIUtil.invokeLaterIfNeeded(() -> NSScrollerHelper.updateBehaviorPreferences());
        }
    };
    private static ClickBehavior ourClickBehavior = null;
    private static final List<Reference<ScrollbarStyleListener>> ourStyleListeners = new ArrayList<Reference<ScrollbarStyleListener>>();

    NSScrollerHelper() {
    }

    private static boolean isOverlayScrollbarSupported() {
        return SystemInfo.isMac && SystemInfo.isMacOSMountainLion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNotificationObserver() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        ID delegateClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"NSScrollerChangesObserver");
        if (!ID.NIL.equals((Object)delegateClass)) {
            if (!Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"handleScrollerStyleChanged:"), (Callback)APPEARANCE_CALLBACK, (String)"v@")) {
                throw new RuntimeException("Cannot add observer method");
            }
            if (!Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"handleBehaviorChanged:"), (Callback)BEHAVIOR_CALLBACK, (String)"v@")) {
                throw new RuntimeException("Cannot add observer method");
            }
            Foundation.registerObjcClassPair((ID)delegateClass);
        }
        ID delegate = Foundation.invoke((String)"NSScrollerChangesObserver", (String)"new", (Object[])new Object[0]);
        try {
            ID center = Foundation.invoke((String)"NSNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]);
            Foundation.invoke((ID)center, (String)"addObserver:selector:name:object:", (Object[])new Object[]{delegate, Foundation.createSelector((String)"handleScrollerStyleChanged:"), Foundation.nsString((String)"NSPreferredScrollerStyleDidChangeNotification"), ID.NIL});
            center = Foundation.invoke((String)"NSDistributedNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]);
            Foundation.invoke((ID)center, (String)"addObserver:selector:name:object:", (Object[])new Object[]{delegate, Foundation.createSelector((String)"handleBehaviorChanged:"), Foundation.nsString((String)"AppleNoRedisplayAppearancePreferenceChanged"), ID.NIL, 2});
        }
        finally {
            pool.drain();
        }
    }

    @Nullable
    public static ClickBehavior getClickBehavior() {
        if (!SystemInfo.isMac) {
            return null;
        }
        return ourClickBehavior;
    }

    private static void updateBehaviorPreferences() {
        if (!SystemInfo.isMac) {
            return;
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke((String)"NSUserDefaults", (String)"standardUserDefaults", (Object[])new Object[0]);
            Foundation.invoke((ID)defaults, (String)"synchronize", (Object[])new Object[0]);
            ourClickBehavior = Foundation.invoke((ID)defaults, (String)"boolForKey:", (Object[])new Object[]{Foundation.nsString((String)"AppleScrollerPagingBehavior")}).intValue() == 1 ? ClickBehavior.JumpToSpot : ClickBehavior.NextPage;
        }
        finally {
            pool.drain();
        }
    }

    @Nullable
    public static Style getScrollerStyle() {
        if (!NSScrollerHelper.isOverlayScrollbarSupported()) {
            return null;
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            if (Foundation.invoke((ID)Foundation.getObjcClass((String)"NSScroller"), (String)"preferredScrollerStyle", (Object[])new Object[0]).intValue() == 1) {
                Style style = Style.Overlay;
                return style;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            pool.drain();
        }
        return Style.Legacy;
    }

    public static void addScrollbarStyleListener(@NotNull ScrollbarStyleListener listener) {
        NSScrollerHelper.processReferences(listener, null, null);
    }

    public static void removeScrollbarStyleListener(@NotNull ScrollbarStyleListener listener) {
        NSScrollerHelper.processReferences(null, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processReferences(ScrollbarStyleListener toAdd, ScrollbarStyleListener toRemove, List<ScrollbarStyleListener> list) {
        List<Reference<ScrollbarStyleListener>> list2 = ourStyleListeners;
        synchronized (list2) {
            Iterator<Reference<ScrollbarStyleListener>> iterator = ourStyleListeners.iterator();
            while (iterator.hasNext()) {
                Reference<ScrollbarStyleListener> reference = iterator.next();
                ScrollbarStyleListener ui = reference.get();
                if (ui == null || ui == toRemove) {
                    iterator.remove();
                    continue;
                }
                if (list == null) continue;
                list.add(ui);
            }
            if (toAdd != null) {
                ourStyleListeners.add(new WeakReference<ScrollbarStyleListener>(toAdd));
            }
        }
    }

    private static void fireStyleChanged() {
        ArrayList<ScrollbarStyleListener> list = new ArrayList<ScrollbarStyleListener>();
        NSScrollerHelper.processReferences(null, null, list);
        for (ScrollbarStyleListener listener : list) {
            listener.styleChanged();
        }
    }

    static {
        if (SystemInfo.isMac) {
            NSScrollerHelper.initNotificationObserver();
            NSScrollerHelper.updateBehaviorPreferences();
        }
    }

    public static interface ScrollbarStyleListener
    extends EventListener {
        public void styleChanged();
    }

    public static enum Style {
        Legacy,
        Overlay;

    }

    public static enum ClickBehavior {
        NextPage,
        JumpToSpot;

    }
}

