/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Range;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.IndexTreePathState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.ui.tree.TreeUtil");
    @NonNls
    @NotNull
    private static final String TREE_UTIL_SCROLL_TIME_STAMP = "TreeUtil.scrollTimeStamp";

    private TreeUtil() {
    }

    public static void collectExpandedPaths(@NotNull JTree tree, @NotNull List<TreePath> paths) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        LOG.assertTrue(root != null);
        TreeUtil.collectExpandedPathsImpl(tree, paths, new TreePath(root));
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Object root = tree.getModel().getRoot();
        TreePath rootPath = new TreePath(root);
        result.addAll(TreeUtil.collectExpandedPaths(tree, rootPath));
        return result;
    }

    @NotNull
    public static <T> List<T> collectSelectedObjectsOfType(@NotNull JTree tree, @NotNull Class<T> clazz) {
        TreePath[] selections = tree.getSelectionPaths();
        if (selections != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (TreePath selection : selections) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (!clazz.isInstance(userObject)) continue;
                result.add(userObject);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree, @NotNull TreePath path2) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (!tree.isExpanded(path2)) {
            return result;
        }
        Object lastPathComponent = path2.getLastPathComponent();
        TreeModel model = tree.getModel();
        if (model.isLeaf(lastPathComponent)) {
            result.add(path2);
        } else {
            boolean pathWasAdded = false;
            for (int i2 = model.getChildCount(lastPathComponent) - 1; i2 >= 0; --i2) {
                TreePath childPath = path2.pathByAddingChild(model.getChild(lastPathComponent, i2));
                if (model.isLeaf(lastPathComponent)) {
                    if (pathWasAdded) continue;
                    result.add(path2);
                    pathWasAdded = true;
                    continue;
                }
                if (tree.isExpanded(childPath)) {
                    result.addAll(TreeUtil.collectExpandedPaths(tree, childPath));
                    continue;
                }
                if (pathWasAdded) continue;
                result.add(path2);
                pathWasAdded = true;
            }
        }
        return result;
    }

    private static boolean collectExpandedPathsImpl(@NotNull JTree tree, @NotNull Collection<TreePath> paths, @NotNull TreePath path2) {
        Object lastPathComponent;
        TreeModel model = tree.getModel();
        if (model.isLeaf(lastPathComponent = path2.getLastPathComponent())) {
            return false;
        }
        boolean hasExpandedChildren = false;
        for (int i2 = model.getChildCount(lastPathComponent) - 1; i2 >= 0; --i2) {
            hasExpandedChildren |= TreeUtil.collectExpandedPathsImpl(tree, paths, path2.pathByAddingChild(model.getChild(lastPathComponent, i2)));
        }
        if (!hasExpandedChildren) {
            paths.add(path2);
            return true;
        }
        return false;
    }

    public static void restoreExpandedPaths(@NotNull JTree tree, @NotNull List<TreePath> paths) {
        for (int i2 = paths.size() - 1; i2 >= 0; --i2) {
            tree.expandPath(paths.get(i2));
        }
    }

    @NotNull
    public static TreePath getPath(@NotNull TreeNode aRootNode, @NotNull TreeNode aNode) {
        Object[] nodes = TreeUtil.getPathFromRootTo(aRootNode, aNode, true);
        return new TreePath(nodes);
    }

    public static boolean isAncestor(@NotNull TreeNode ancestor, @NotNull TreeNode node) {
        for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(@NotNull TreePath ancestor, @NotNull TreePath path2) {
        if (path2.getPathCount() < ancestor.getPathCount()) {
            return false;
        }
        for (int i2 = 0; i2 < ancestor.getPathCount(); ++i2) {
            if (path2.getPathComponent(i2).equals(ancestor.getPathComponent(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDescendants(@NotNull TreePath path2, @NotNull TreePath[] paths) {
        for (TreePath ancestor : paths) {
            if (!TreeUtil.isAncestor(ancestor, path2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TreePath getPathFromRoot(@NotNull TreeNode node) {
        Object[] path2 = TreeUtil.getPathFromRootTo(null, node, false);
        return new TreePath(path2);
    }

    @NotNull
    private static TreeNode[] getPathFromRootTo(@Nullable TreeNode root, @NotNull TreeNode node, boolean includeRoot) {
        int height = 0;
        for (TreeNode n = node; n != root; n = n.getParent()) {
            ++height;
        }
        TreeNode[] path2 = new TreeNode[includeRoot ? height + 1 : height];
        int i2 = path2.length - 1;
        TreeNode n = node;
        while (i2 >= 0) {
            path2[i2--] = n;
            n = n.getParent();
        }
        return path2;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, @NotNull TreeModel model, Object parent) {
        for (int i2 = 0; i2 < model.getChildCount(parent); ++i2) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i2);
            if (!childNode.getUserObject().equals(object)) continue;
            return childNode;
        }
        return null;
    }

    public static void removeSelected(@NotNull JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path2 : paths) {
            TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), path2).restoreSelection(tree);
        }
    }

    public static void removeLastPathComponent(@NotNull JTree tree, @NotNull TreePath pathToBeRemoved) {
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), pathToBeRemoved).restoreSelection(tree);
    }

    @Nullable
    public static DefaultMutableTreeNode findNodeWithObject(@NotNull DefaultMutableTreeNode aRoot, Object aObject) {
        if (Comparing.equal((Object)aRoot.getUserObject(), (Object)aObject)) {
            return aRoot;
        }
        for (int i2 = 0; i2 < aRoot.getChildCount(); ++i2) {
            DefaultMutableTreeNode candidate = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)aRoot.getChildAt(i2), aObject);
            if (null == candidate) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static TreePath findCommonPath(@NotNull TreePath[] treePaths) {
        LOG.assertTrue(TreeUtil.areComponentsEqual(treePaths, 0));
        TreePath result = new TreePath(treePaths[0].getPathComponent(0));
        int pathIndex = 1;
        while (TreeUtil.areComponentsEqual(treePaths, pathIndex)) {
            result = result.pathByAddingChild(treePaths[0].getPathComponent(pathIndex));
            ++pathIndex;
        }
        return result;
    }

    @NotNull
    public static ActionCallback selectFirstNode(@NotNull JTree tree) {
        TreePath selectionPath = TreeUtil.getFirstNodePath(tree);
        return TreeUtil.selectPath(tree, selectionPath);
    }

    @NotNull
    public static TreePath getFirstNodePath(@NotNull JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        if (!tree.isRootVisible() && model.getChildCount(root) > 0) {
            selectionPath = selectionPath.pathByAddingChild(model.getChild(root, 0));
        }
        return selectionPath;
    }

    @NotNull
    public static TreePath getFirstLeafNodePath(@NotNull JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        while (model.getChildCount(root) > 0) {
            Object child = model.getChild(root, 0);
            selectionPath = selectionPath.pathByAddingChild(child);
            root = child;
        }
        return selectionPath;
    }

    @NotNull
    private static IndexTreePathState removeLastPathComponent(@NotNull DefaultTreeModel model, @NotNull TreePath pathToBeRemoved) {
        IndexTreePathState selectionState = new IndexTreePathState(pathToBeRemoved);
        if (((MutableTreeNode)pathToBeRemoved.getLastPathComponent()).getParent() == null) {
            return selectionState;
        }
        model.removeNodeFromParent((MutableTreeNode)pathToBeRemoved.getLastPathComponent());
        return selectionState;
    }

    private static boolean areComponentsEqual(@NotNull TreePath[] paths, int componentIndex) {
        if (paths[0].getPathCount() <= componentIndex) {
            return false;
        }
        Object pathComponent = paths[0].getPathComponent(componentIndex);
        for (TreePath treePath : paths) {
            if (treePath.getPathCount() <= componentIndex) {
                return false;
            }
            if (pathComponent.equals(treePath.getPathComponent(componentIndex))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static TreePath[] removeDuplicates(@NotNull TreePath[] paths) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path2 : paths) {
            if (result.contains(path2)) continue;
            result.add(path2);
        }
        return result.toArray(new TreePath[result.size()]);
    }

    @NotNull
    public static TreePath[] selectMaximals(@Nullable TreePath[] paths) {
        if (paths == null) {
            return new TreePath[0];
        }
        TreePath[] noDuplicates = TreeUtil.removeDuplicates(paths);
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path2 : noDuplicates) {
            ArrayList<TreePath> otherPaths = new ArrayList<TreePath>(Arrays.asList(noDuplicates));
            otherPaths.remove(path2);
            if (TreeUtil.isDescendants(path2, otherPaths.toArray(new TreePath[otherPaths.size()]))) continue;
            result.add(path2);
        }
        return result.toArray(new TreePath[result.size()]);
    }

    public static void sort(@NotNull DefaultTreeModel model, @Nullable Comparator comparator) {
        TreeUtil.sort((DefaultMutableTreeNode)model.getRoot(), comparator);
    }

    public static void sort(@NotNull DefaultMutableTreeNode node, @Nullable Comparator comparator) {
        TreeUtil.sortRecursively(node, comparator);
    }

    public static <T extends MutableTreeNode> void sortRecursively(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        TreeUtil.sortChildren(node, comparator);
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            TreeUtil.sortRecursively((MutableTreeNode)node.getChildAt(i2), comparator);
        }
    }

    public static <T extends MutableTreeNode> void sortChildren(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        List<TreeNode> children = TreeUtil.listChildren(node);
        Collections.sort(children, comparator);
        for (int i2 = node.getChildCount() - 1; i2 >= 0; --i2) {
            node.remove(i2);
        }
        TreeUtil.addChildrenTo(node, children);
    }

    public static void addChildrenTo(@NotNull MutableTreeNode node, @NotNull List<? extends TreeNode> children) {
        for (TreeNode treeNode : children) {
            MutableTreeNode child = (MutableTreeNode)treeNode;
            node.insert(child, node.getChildCount());
        }
    }

    public static boolean traverse(@NotNull TreeNode node, @NotNull Traverse traverse) {
        int childCount = node.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            if (TreeUtil.traverse(node.getChildAt(i2), traverse)) continue;
            return false;
        }
        return traverse.accept(node);
    }

    public static boolean traverseDepth(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (!traverse.accept(node)) {
            return false;
        }
        int childCount = node.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            if (TreeUtil.traverseDepth(node.getChildAt(i2), traverse)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2) {
        return TreeUtil.selectPath(tree, path2, true);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2, boolean center) {
        tree.makeVisible(path2);
        if (center) {
            return TreeUtil.showRowCentred(tree, tree.getRowForPath(path2));
        }
        int row = tree.getRowForPath(path2);
        return TreeUtil.showAndSelect(tree, row - 2, row + 2, row, -1);
    }

    @NotNull
    public static ActionCallback moveDown(@NotNull JTree tree) {
        int size = tree.getRowCount();
        int row = tree.getLeadSelectionRow();
        if (row < size - 1) {
            return TreeUtil.showAndSelect(tree, ++row, row + 2, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        return ActionCallback.DONE;
    }

    @NotNull
    public static ActionCallback moveUp(@NotNull JTree tree) {
        int row = tree.getLeadSelectionRow();
        if (row > 0) {
            return TreeUtil.showAndSelect(tree, --row - 2, row, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        return ActionCallback.DONE;
    }

    @NotNull
    public static ActionCallback movePageUp(@NotNull JTree tree) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        if (visible <= 0) {
            return TreeUtil.moveHome(tree);
        }
        int decrement = visible - 1;
        int row = Math.max(TreeUtil.getSelectedRow(tree) - decrement, 0);
        int top = TreeUtil.getFirstVisibleRow(tree) - decrement;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, row, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    public static ActionCallback movePageDown(@NotNull JTree tree) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        if (visible <= 0) {
            return TreeUtil.moveEnd(tree);
        }
        int size = tree.getRowCount();
        int increment = visible - 1;
        int index = Math.min(TreeUtil.getSelectedRow(tree) + increment, size - 1);
        int top = TreeUtil.getFirstVisibleRow(tree) + increment;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, index, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    private static ActionCallback moveHome(@NotNull JTree tree) {
        return TreeUtil.showRowCentred(tree, 0);
    }

    @NotNull
    private static ActionCallback moveEnd(@NotNull JTree tree) {
        return TreeUtil.showRowCentred(tree, tree.getRowCount() - 1);
    }

    @NotNull
    private static ActionCallback showRowCentred(@NotNull JTree tree, int row) {
        return TreeUtil.showRowCentered(tree, row, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally) {
        return TreeUtil.showRowCentered(tree, row, centerHorizontally, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally, boolean scroll) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        int top = visible > 0 ? row - (visible - 1) / 2 : row;
        int bottom = visible > 0 ? top + visible - 1 : row;
        return TreeUtil.showAndSelect(tree, top, bottom, row, -1, false, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous) {
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection) {
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, true, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll) {
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll, boolean resetSelection) {
        Rectangle bottomBounds;
        TreePath path2 = tree.getPathForRow(row);
        if (path2 == null) {
            return ActionCallback.DONE;
        }
        int size = tree.getRowCount();
        if (size == 0) {
            tree.clearSelection();
            return ActionCallback.DONE;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if (row >= tree.getRowCount()) {
            return ActionCallback.DONE;
        }
        boolean okToScroll = true;
        if (tree.isShowing()) {
            if (!tree.isValid()) {
                tree.validate();
            }
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isUnitTestMode()) {
                okToScroll = false;
            }
        }
        Runnable selectRunnable = () -> {
            if (!tree.isRowSelected(row)) {
                if (addToSelection) {
                    tree.getSelectionModel().addSelectionPath(tree.getPathForRow(row));
                } else {
                    tree.setSelectionRow(row);
                }
            } else if (resetSelection && !addToSelection) {
                tree.setSelectionRow(row);
            }
        };
        if (!okToScroll || !scroll) {
            selectRunnable.run();
            return ActionCallback.DONE;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        if (rowBounds == null) {
            return ActionCallback.DONE;
        }
        Rectangle topBounds = tree.getRowBounds(top);
        if (topBounds == null) {
            topBounds = rowBounds;
        }
        if ((bottomBounds = tree.getRowBounds(bottom)) == null) {
            bottomBounds = rowBounds;
        }
        Rectangle bounds = topBounds.union(bottomBounds);
        bounds.x = rowBounds.x;
        bounds.width = rowBounds.width;
        Rectangle visible = tree.getVisibleRect();
        if (visible.contains(bounds)) {
            selectRunnable.run();
            return ActionCallback.DONE;
        }
        Component comp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path2.getLastPathComponent(), true, true, false, row, false);
        if (comp instanceof SimpleColoredComponent) {
            SimpleColoredComponent renderer = (SimpleColoredComponent)comp;
            Dimension scrollableSize = renderer.computePreferredSize(true);
            bounds.width = scrollableSize.width;
        }
        ActionCallback callback = new ActionCallback();
        selectRunnable.run();
        Range<Integer> range = TreeUtil.getExpandControlRange(tree, path2);
        if (range != null) {
            int delta = bounds.x - (Integer)range.getFrom();
            bounds.x -= delta;
            bounds.width -= delta;
        }
        if (visible.width < bounds.width) {
            bounds.width = visible.width;
        }
        if (tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
            bounds.x = 0;
        }
        LOG.debug("tree scroll: ", new Object[]{path2});
        tree.scrollRectToVisible(bounds);
        Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
        long stamp = property instanceof Long ? (Long)property + 1L : Long.MIN_VALUE;
        tree.putClientProperty(TREE_UTIL_SCROLL_TIME_STAMP, stamp);
        int offset = rowBounds.y - bounds.y;
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        TreeUtil.scrollToVisible(tree, path2, bounds, offset, stamp, callback::setDone, builder, 3);
        return callback;
    }

    private static void scrollToVisible(JTree tree, TreePath path2, Rectangle bounds, int offset, long expected, Runnable done2, AbstractTreeBuilder builder, int attempt) {
        Runnable scroll = () -> {
            Rectangle pathBounds;
            Rectangle rectangle = pathBounds = attempt <= 0 ? null : tree.getPathBounds(path2);
            if (pathBounds != null) {
                Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
                long stamp = property instanceof Long ? (Long)property : Long.MAX_VALUE;
                LOG.debug("tree scroll ", new Object[]{attempt, stamp == expected ? ": try again: " : ": ignore: ", path2});
                if (stamp == expected) {
                    bounds.y = pathBounds.y - offset;
                    Rectangle visible = tree.getVisibleRect();
                    if (bounds.y < visible.y || bounds.y > visible.y + Math.max(0, visible.height - bounds.height)) {
                        tree.scrollRectToVisible(bounds);
                        TreeUtil.scrollToVisible(tree, path2, bounds, offset, expected, done2, builder, attempt - 1);
                        return;
                    }
                }
            }
            done2.run();
        };
        SwingUtilities.invokeLater(builder == null ? scroll : () -> builder.getReady(TreeUtil.class).doWhenDone(scroll));
    }

    private static int getSelectedRow(@NotNull JTree tree) {
        return tree.getRowForPath(tree.getSelectionPath());
    }

    private static int getFirstVisibleRow(@NotNull JTree tree) {
        Rectangle visible = tree.getVisibleRect();
        int row = -1;
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            Rectangle bounds = tree.getRowBounds(i2);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            row = i2;
            break;
        }
        return row;
    }

    public static int getVisibleRowCount(@NotNull JTree tree) {
        Rectangle visible = tree.getVisibleRect();
        if (visible == null) {
            return 0;
        }
        int count = 0;
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            Rectangle bounds = tree.getRowBounds(i2);
            if (bounds == null || visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            ++count;
        }
        return count;
    }

    public static int getVisibleRowCountForFixedRowHeight(@NotNull JTree tree) {
        Rectangle bounds = tree.getRowBounds(0);
        int rowHeight = bounds == null ? 0 : bounds.height;
        return rowHeight == 0 ? tree.getVisibleRowCount() : tree.getVisibleRect().height / rowHeight;
    }

    public static void installActions(final @NotNull JTree tree) {
        tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageUp(tree);
            }
        });
        tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageDown(tree);
            }
        });
        tree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveUp(tree);
            }
        });
        tree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveDown(tree);
            }
        });
        TreeUtil.copyAction(tree, "selectLast", "selectLastChangeLead");
        TreeUtil.copyAction(tree, "selectFirst", "selectFirstChangeLead");
        InputMap inputMap = tree.getInputMap(0);
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollUpChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollDownChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectNext", (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectPrevious", (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectLast", (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectFirst", (KeyStroke)KeyStroke.getKeyStroke(36, 0));
    }

    private static void copyAction(@NotNull JTree tree, String original, String copyTo) {
        Action action = tree.getActionMap().get(original);
        if (action != null) {
            tree.getActionMap().put(copyTo, action);
        }
    }

    public static void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        tree.expandPath(new TreePath(root));
        if (leadSelectionPath != null) {
            Object[] path2 = leadSelectionPath.getPath();
            Object[] pathToSelect = new Object[path2.length > keepSelectionLevel && keepSelectionLevel >= 0 ? keepSelectionLevel : path2.length];
            System.arraycopy(path2, 0, pathToSelect, 0, pathToSelect.length);
            if (pathToSelect.length == 0) {
                return;
            }
            TreeUtil.selectPath(tree, new TreePath(pathToSelect));
        }
    }

    public static void selectNode(@NotNull JTree tree, TreeNode node) {
        TreeUtil.selectPath(tree, TreeUtil.getPathFromRoot(node));
    }

    public static void moveSelectedRow(@NotNull JTree tree, int direction) {
        TreePath selectionPath = tree.getSelectionPath();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        int idx = parent.getIndex(treeNode);
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        TreeUtil.selectNode(tree, treeNode);
    }

    @NotNull
    public static ArrayList<TreeNode> childrenToArray(@NotNull TreeNode node) {
        return (ArrayList)TreeUtil.listChildren(node);
    }

    @NotNull
    public static List<TreeNode> listChildren(@NotNull TreeNode node) {
        int size = node.getChildCount();
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            TreeNode child = node.getChildAt(i2);
            LOG.assertTrue(child != null);
            result.add(child);
        }
        return result;
    }

    public static void expandRootChildIfOnlyOne(@Nullable JTree tree) {
        if (tree == null) {
            return;
        }
        Runnable runnable = () -> {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
            tree.expandPath(new TreePath(new Object[]{root}));
            if (root.getChildCount() == 1) {
                TreeNode firstChild = root.getFirstChild();
                tree.expandPath(new TreePath(new Object[]{root, firstChild}));
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void expandAll(@NotNull JTree tree) {
        int rowCount;
        tree.expandPath(new TreePath(tree.getModel().getRoot()));
        int oldRowCount = 0;
        while ((rowCount = tree.getRowCount()) != oldRowCount) {
            oldRowCount = rowCount;
            for (int i2 = 0; i2 < rowCount; ++i2) {
                tree.expandRow(i2);
            }
        }
    }

    public static void expand(@NotNull JTree tree, int levels) {
        TreeUtil.expand(tree, new TreePath(tree.getModel().getRoot()), levels);
    }

    public static boolean expandWithResult(@NotNull JTree tree, int levels) {
        return TreeUtil.expand(tree, new TreePath(tree.getModel().getRoot()), levels);
    }

    private static boolean expand(@NotNull JTree tree, @NotNull TreePath path2, int levels) {
        if (levels == 0) {
            return false;
        }
        tree.expandPath(path2);
        TreeNode node = (TreeNode)path2.getLastPathComponent();
        Enumeration<? extends TreeNode> children = node.children();
        boolean isReady = true;
        while (children.hasMoreElements()) {
            if (TreeUtil.expand(tree, path2.pathByAddingChild(children.nextElement()), levels - 1)) continue;
            isReady = false;
        }
        return isReady;
    }

    @NotNull
    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree) {
        return TreeUtil.selectInTree(node, requestFocus, tree, true);
    }

    @NotNull
    public static ActionCallback selectInTree(@Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (node == null) {
            return ActionCallback.DONE;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            tree.requestFocus();
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    @NotNull
    public static ActionCallback selectInTree(Project project, @Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (node == null) {
            return ActionCallback.DONE;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            ActionCallback result = new ActionCallback(2);
            IdeFocusManager.getInstance(project).requestFocus(tree, true).notifyWhenDone(result);
            TreeUtil.selectPath(tree, treePath, center).notifyWhenDone(result);
            return result;
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree, @NotNull TreePath treePath) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        TreePath[] selections = tree.getSelectionPaths();
        if (selections != null) {
            for (TreePath selection : selections) {
                if (!treePath.isDescendant(selection)) continue;
                result.add(selection);
            }
        }
        return result;
    }

    public static void unselect(@NotNull JTree tree, @NotNull DefaultMutableTreeNode node) {
        TreePath rootPath = new TreePath(node.getPath());
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                if (selectionPath.getPathCount() <= rootPath.getPathCount() || !rootPath.isDescendant(selectionPath)) continue;
                tree.removeSelectionPath(selectionPath);
            }
        }
    }

    @Nullable
    public static Range<Integer> getExpandControlRange(@NotNull JTree aTree, @Nullable TreePath path2) {
        TreeModel treeModel = aTree.getModel();
        BasicTreeUI basicTreeUI = (BasicTreeUI)aTree.getUI();
        Icon expandedIcon = basicTreeUI.getExpandedIcon();
        Range box = null;
        if (path2 != null && !treeModel.isLeaf(path2.getLastPathComponent())) {
            Insets i2 = aTree.getInsets();
            int boxWidth = expandedIcon != null ? expandedIcon.getIconWidth() : 8;
            int boxLeftX = i2 != null ? i2.left : 0;
            boolean leftToRight = aTree.getComponentOrientation().isLeftToRight();
            int depthOffset = TreeUtil.getDepthOffset(aTree);
            int totalChildIndent = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            if (leftToRight) {
                boxLeftX += (path2.getPathCount() + depthOffset - 2) * totalChildIndent + basicTreeUI.getLeftChildIndent() - boxWidth / 2;
            }
            int boxRightX = boxLeftX + boxWidth;
            box = new Range((Comparable)Integer.valueOf(boxLeftX), (Comparable)Integer.valueOf(boxRightX));
        }
        return box;
    }

    public static int getDepthOffset(@NotNull JTree aTree) {
        if (aTree.isRootVisible()) {
            return aTree.getShowsRootHandles() ? 1 : 0;
        }
        return aTree.getShowsRootHandles() ? 0 : -1;
    }

    @NotNull
    public static RelativePoint getPointForSelection(@NotNull JTree aTree) {
        int[] rows = aTree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            return RelativePoint.getCenterOf((JComponent)aTree);
        }
        return TreeUtil.getPointForRow(aTree, rows[rows.length - 1]);
    }

    @NotNull
    public static RelativePoint getPointForRow(@NotNull JTree aTree, int aRow) {
        return TreeUtil.getPointForPath(aTree, aTree.getPathForRow(aRow));
    }

    @NotNull
    public static RelativePoint getPointForPath(@NotNull JTree aTree, TreePath path2) {
        Rectangle rowBounds = aTree.getPathBounds(path2);
        rowBounds.x += 20;
        return TreeUtil.getPointForBounds(aTree, rowBounds);
    }

    @NotNull
    public static RelativePoint getPointForBounds(JComponent aComponent, @NotNull Rectangle aBounds) {
        return new RelativePoint((Component)aComponent, new Point(aBounds.x, (int)aBounds.getMaxY()));
    }

    public static boolean isOverSelection(@NotNull JTree tree, @NotNull Point point) {
        TreePath path2 = tree.getPathForLocation(point.x, point.y);
        return path2 != null && tree.getSelectionModel().isPathSelected(path2);
    }

    public static void dropSelectionButUnderPoint(@NotNull JTree tree, @NotNull Point treePoint) {
        TreePath toRetain = tree.getPathForLocation(treePoint.x, treePoint.y);
        if (toRetain == null) {
            return;
        }
        TreePath[] selection = tree.getSelectionModel().getSelectionPaths();
        for (TreePath each : selection = selection == null ? new TreePath[]{} : selection) {
            if (toRetain.equals(each)) continue;
            tree.getSelectionModel().removeSelectionPath(each);
        }
    }

    public static void ensureSelection(@NotNull JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath each : paths) {
                if (tree.getRowForPath(each) < 0 || !tree.isVisible(each)) continue;
                return;
            }
        }
        for (int eachRow = 0; eachRow < tree.getRowCount(); ++eachRow) {
            TreePath eachPath = tree.getPathForRow(eachRow);
            if (eachPath == null || !tree.isVisible(eachPath)) continue;
            tree.setSelectionPath(eachPath);
            break;
        }
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, @NotNull Comparator<? super T> comparator) {
        int index = TreeUtil.indexedBinarySearch(parent, child, comparator);
        if (index >= 0) {
            LOG.error("Node " + child + " is already added to " + parent);
            return;
        }
        int insertionPoint = -(index + 1);
        if (model != null) {
            model.insertNodeInto(child, parent, insertionPoint);
        } else {
            parent.insert(child, insertionPoint);
        }
    }

    public static <T extends TreeNode> int indexedBinarySearch(@NotNull T parent, @NotNull T key, @NotNull Comparator<? super T> comparator) {
        int low = 0;
        int high = parent.getChildCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            TreeNode treeNode = parent.getChildAt(mid);
            int cmp = comparator.compare(treeNode, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @NotNull
    public static Comparator<TreePath> getDisplayOrderComparator(@NotNull JTree tree) {
        return Comparator.comparingInt(tree::getRowForPath);
    }

    @FunctionalInterface
    public static interface Traverse {
        public boolean accept(Object var1);
    }
}

