/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModuleContextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertContext
extends ConvertContext {
    @Override
    public final XmlTag getTag() {
        return this.getInvocationElement().getXmlTag();
    }

    @Override
    @Nullable
    public XmlElement getXmlElement() {
        return this.getInvocationElement().getXmlElement();
    }

    @Override
    @NotNull
    public final XmlFile getFile() {
        return DomUtil.getFile(this.getInvocationElement());
    }

    @Override
    public Module getModule() {
        DomFileElement fileElement = DomUtil.getFileElement(this.getInvocationElement());
        if (fileElement == null) {
            XmlElement xmlElement = this.getInvocationElement().getXmlElement();
            return xmlElement == null ? null : ModuleUtilCore.findModuleForPsiElement(xmlElement);
        }
        return fileElement.isValid() ? fileElement.getRootElement().getModule() : null;
    }

    @Override
    @Nullable
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope scope = null;
        Module[] modules = this.getConvertContextModules();
        if (modules.length != 0) {
            PsiFile file = this.getFile();
            VirtualFile virtualFile2 = (file = file.getOriginalFile()).getVirtualFile();
            if (virtualFile2 != null) {
                boolean tests = TestSourcesFilter.isTestSources(virtualFile2, file.getProject());
                for (Module module : modules) {
                    scope = scope == null ? module.getModuleRuntimeScope(tests) : scope.union(module.getModuleRuntimeScope(tests));
                }
            }
        }
        return scope;
    }

    @NotNull
    private Module[] getConvertContextModules() {
        Module[] modules = ModuleContextProvider.getModules(this.getFile());
        if (modules.length > 0) {
            return modules;
        }
        Module module = this.getModule();
        if (module != null) {
            return new Module[]{module};
        }
        return Module.EMPTY_ARRAY;
    }
}

