/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.ide.IconProvider;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomIconProvider;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.NameValue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementPresentationManager {
    private static final ConcurrentFactoryMap<Class, Method> ourNameValueMethods = new ConcurrentFactoryMap<Class, Method>(){

        @Nullable
        protected Method create(Class key) {
            for (Method method : ReflectionUtil.getClassPublicMethods((Class)key)) {
                if (JavaMethod.getMethod(key, method).getAnnotation(NameValue.class) == null) continue;
                return method;
            }
            return null;
        }
    };
    private static final Function<Object, String> DEFAULT_NAMER = element -> ElementPresentationManager.getElementName(element);
    private static final List<Function<Object, String>> ourNameProviders = new ArrayList<Function<Object, String>>();
    private static final List<Function<Object, String>> ourDocumentationProviders = new ArrayList<Function<Object, String>>();
    private static final List<Function<Object, Icon>> ourIconProviders = new ArrayList<Function<Object, Icon>>();
    public static final NullableFunction<Object, String> NAMER;

    public static ElementPresentationManager getInstance() {
        return ServiceManager.getService(ElementPresentationManager.class);
    }

    @NotNull
    public <T> Object[] createVariants(Collection<T> elements) {
        return this.createVariants(elements, DEFAULT_NAMER);
    }

    @NotNull
    public <T> Object[] createVariants(Collection<T> elements, int iconFlags) {
        return this.createVariants(elements, DEFAULT_NAMER, iconFlags);
    }

    @NotNull
    public <T> Object[] createVariants(Collection<T> elements, Function<T, String> namer) {
        return this.createVariants(elements, namer, 0);
    }

    @Deprecated
    public abstract Object createVariant(Object var1, String var2, PsiElement var3);

    @NotNull
    public abstract <T> Object[] createVariants(Collection<T> var1, Function<T, String> var2, int var3);

    public static void registerNameProvider(Function<Object, String> function) {
        ourNameProviders.add(function);
    }

    public static void registerDocumentationProvider(Function<Object, String> function) {
        ourDocumentationProviders.add(function);
    }

    public static <T> NullableFunction<T, String> NAMER() {
        return o -> ElementPresentationManager.getElementName(o);
    }

    public static <T> NullableFunction<T, String> namer() {
        return NAMER;
    }

    @Nullable
    public static String getElementName(@NotNull Object element) {
        String s;
        for (Function<Object, String> function : ourNameProviders) {
            s = (String)function.fun(element);
            if (s == null) continue;
            return s;
        }
        Object o = ElementPresentationManager.invokeNameValueMethod(element);
        if (o == null || o instanceof String) {
            return (String)o;
        }
        if (o instanceof GenericValue) {
            Object value;
            GenericValue gv = (GenericValue)o;
            s = gv.getStringValue();
            if (s == null && (value = gv.getValue()) != null) {
                return String.valueOf(value);
            }
            return s;
        }
        return null;
    }

    @Nullable
    public static String getDocumentationForElement(Object element) {
        for (Function<Object, String> function : ourDocumentationProviders) {
            String s = (String)function.fun(element);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public static Object invokeNameValueMethod(@NotNull Object element) {
        Method nameValueMethod = ElementPresentationManager.findNameValueMethod(element.getClass());
        if (nameValueMethod == null) {
            return null;
        }
        return DomReflectionUtil.invokeMethod(nameValueMethod, element, new Object[0]);
    }

    public static String getTypeNameForObject(Object o) {
        Object firstImpl = ModelMergerUtil.getFirstImplementation(o);
        o = firstImpl != null ? firstImpl : o;
        String typeName = TypePresentationService.getService().getTypeName(o);
        if (typeName != null) {
            return typeName;
        }
        if (o instanceof DomElement) {
            DomElement element = (DomElement)o;
            return StringUtil.capitalizeWords((String)element.getNameStrategy().splitIntoWords(element.getXmlElementName()), (boolean)true);
        }
        return TypePresentationService.getDefaultTypeName(o.getClass());
    }

    public static Icon getIcon(@NotNull Object o) {
        Icon[] icons;
        for (Function<Object, Icon> function : ourIconProviders) {
            Icon icon = (Icon)function.fun(o);
            if (icon == null) continue;
            return icon;
        }
        if (o instanceof DomElement) {
            DomElement domElement = (DomElement)o;
            boolean dumb = DumbService.getInstance(domElement.getManager().getProject()).isDumb();
            for (IconProvider provider : (IconProvider[])IconProvider.EXTENSION_POINT_NAME.getExtensions()) {
                Icon icon;
                if (!(provider instanceof DomIconProvider) || dumb && !DumbService.isDumbAware(provider) || (icon = ((DomIconProvider)provider).getIcon(domElement, 0)) == null) continue;
                return icon;
            }
        }
        if ((icons = ElementPresentationManager.getIconsForClass(o.getClass(), o)) != null && icons.length > 0) {
            return icons[0];
        }
        return null;
    }

    @Nullable
    public static Icon getIconOld(Object o) {
        for (Function<Object, Icon> function : ourIconProviders) {
            Icon icon = (Icon)function.fun(o);
            if (icon == null) continue;
            return icon;
        }
        Icon[] icons = ElementPresentationManager.getIconsForClass(o.getClass(), o);
        if (icons != null && icons.length > 0) {
            return icons[0];
        }
        return null;
    }

    @Nullable
    private static <T> T getFirst(@Nullable T[] array) {
        return array == null || array.length == 0 ? null : (T)array[0];
    }

    @Nullable
    public static Icon getIconForClass(Class clazz) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIconsForClass(clazz, null));
    }

    @Nullable
    private static Icon[] getIconsForClass(Class clazz, @Nullable Object o) {
        Icon icon;
        TypePresentationService service = TypePresentationService.getService();
        Icon icon2 = icon = o == null ? service.getTypeIcon(clazz) : service.getIcon(o);
        if (icon != null) {
            return new Icon[]{icon};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method findNameValueMethod(Class<?> aClass) {
        ConcurrentFactoryMap<Class, Method> concurrentFactoryMap = ourNameValueMethods;
        synchronized (concurrentFactoryMap) {
            return (Method)ourNameValueMethods.get(aClass);
        }
    }

    @Nullable
    public static <T> T findByName(Collection<T> collection, String name) {
        return (T)ContainerUtil.find(collection, object -> Comparing.equal((String)name, (String)ElementPresentationManager.getElementName(object), (boolean)true));
    }

    static {
        ourIconProviders.add((Function<Object, Icon>)((NullableFunction)o -> o instanceof Iconable ? ((Iconable)o).getIcon(2) : null));
        NAMER = o -> ElementPresentationManager.getElementName(o);
    }
}

