/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.XmlName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatedXmlNameImpl
implements EvaluatedXmlName {
    private static final Key<CachedValue<FactoryMap<String, List<String>>>> NAMESPACE_PROVIDER_KEY = Key.create((String)"NamespaceProvider");
    private static final Map<EvaluatedXmlNameImpl, EvaluatedXmlNameImpl> ourInterned = ContainerUtil.newConcurrentMap();
    private final XmlName myXmlName;
    private final String myNamespaceKey;
    private final boolean myEqualToParent;

    private EvaluatedXmlNameImpl(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        this.myXmlName = xmlName;
        this.myNamespaceKey = namespaceKey;
        this.myEqualToParent = equalToParent;
    }

    @NotNull
    public final String getLocalName() {
        return this.myXmlName.getLocalName();
    }

    @Override
    public final XmlName getXmlName() {
        return this.myXmlName;
    }

    @Override
    public final EvaluatedXmlName evaluateChildName(@NotNull XmlName name) {
        String namespaceKey = name.getNamespaceKey();
        boolean equalToParent = Comparing.equal((String)namespaceKey, (String)this.myNamespaceKey);
        if (namespaceKey == null) {
            namespaceKey = this.myNamespaceKey;
        }
        return EvaluatedXmlNameImpl.createEvaluatedXmlName(name, namespaceKey, equalToParent);
    }

    public String toString() {
        return (this.myNamespaceKey == null ? "" : this.myNamespaceKey + " : ") + this.myXmlName.getLocalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EvaluatedXmlNameImpl)) {
            return false;
        }
        EvaluatedXmlNameImpl that = (EvaluatedXmlNameImpl)o;
        if (this.myEqualToParent != that.myEqualToParent) {
            return false;
        }
        if (this.myNamespaceKey != null ? !this.myNamespaceKey.equals(that.myNamespaceKey) : that.myNamespaceKey != null) {
            return false;
        }
        return this.myXmlName.equals(that.myXmlName);
    }

    public int hashCode() {
        int result = this.myXmlName.hashCode();
        result = 31 * result + (this.myNamespaceKey != null ? this.myNamespaceKey.hashCode() : 0);
        result = 31 * result + (this.myEqualToParent ? 1 : 0);
        return result;
    }

    public final boolean isNamespaceAllowed(DomFileElement element, String namespace) {
        if (this.myNamespaceKey == null || this.myEqualToParent) {
            return true;
        }
        XmlFile file = element.getFile();
        return EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getAllowedNamespaces(file));
    }

    @NotNull
    private List<String> getAllowedNamespaces(final XmlFile file) {
        CachedValue value = (CachedValue)file.getUserData(NAMESPACE_PROVIDER_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(file.getProject()).createCachedValue(() -> {
                ConcurrentFactoryMap<String, List<String>> map = new ConcurrentFactoryMap<String, List<String>>(){

                    protected List<String> create(String key) {
                        DomFileDescription<?> description = DomManager.getDomManager(file.getProject()).getDomFileDescription(file);
                        if (description == null) {
                            return Collections.emptyList();
                        }
                        return description.getAllowedNamespaces(key, file);
                    }
                };
                return CachedValueProvider.Result.create(map, file);
            }, false);
            file.putUserData(NAMESPACE_PROVIDER_KEY, value);
        }
        List list = (List)((FactoryMap)value.getValue()).get((Object)this.myNamespaceKey);
        assert (list != null);
        return list;
    }

    private static boolean isNamespaceAllowed(String namespace, List<String> list) {
        return list.contains(namespace) || StringUtil.isEmpty((String)namespace) && list.isEmpty();
    }

    @Override
    public final boolean isNamespaceAllowed(String namespace, XmlFile file, boolean qualified) {
        return this.myNamespaceKey == null || this.myEqualToParent && !qualified || EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getNamespaceList(file));
    }

    @Override
    @NotNull
    @NonNls
    public final String getNamespace(@NotNull XmlElement parentElement, XmlFile file) {
        List<String> strings;
        String xmlElementNamespace = EvaluatedXmlNameImpl.getXmlElementNamespace(parentElement);
        if (!(this.myNamespaceKey == null || this.myEqualToParent || (strings = this.getAllowedNamespaces(file)).isEmpty() || strings.contains(xmlElementNamespace))) {
            return strings.get(0);
        }
        return xmlElementNamespace;
    }

    private static String getXmlElementNamespace(XmlElement parentElement) {
        if (parentElement instanceof XmlTag) {
            return ((XmlTag)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlAttribute) {
            return ((XmlAttribute)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlFile) {
            XmlTag tag;
            XmlDocument document = ((XmlFile)parentElement).getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                return tag.getNamespace();
            }
            return "";
        }
        throw new AssertionError((Object)("Can't get namespace of " + parentElement));
    }

    private List<String> getNamespaceList(XmlFile file) {
        return this.getAllowedNamespaces(file);
    }

    public static EvaluatedXmlNameImpl createEvaluatedXmlName(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        EvaluatedXmlNameImpl name = new EvaluatedXmlNameImpl(xmlName, namespaceKey, equalToParent);
        EvaluatedXmlNameImpl interned = ourInterned.get(name);
        if (interned != null) {
            return interned;
        }
        ourInterned.put(name, name);
        return name;
    }
}

