/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaMethodSignature {
    private final String myMethodName;
    private final Class[] myMethodParameters;

    public JavaMethodSignature(String methodName, Class ... methodParameters) {
        this.myMethodName = methodName;
        this.myMethodParameters = methodParameters.length == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : methodParameters;
    }

    public JavaMethodSignature(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    @Nullable
    public final Method findMethod(Class aClass) {
        Method method = this.getDeclaredMethod(aClass);
        if (method == null && aClass.isInterface()) {
            method = this.getDeclaredMethod(Object.class);
        }
        return method;
    }

    private boolean processMethods(Class aClass, Processor<Method> processor) {
        return this.processMethodWithSupers(aClass, this.findMethod(aClass), processor);
    }

    @Nullable
    private Method getDeclaredMethod(Class aClass) {
        Method method = ReflectionUtil.getMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters);
        return method == null ? ReflectionUtil.getDeclaredMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters) : method;
    }

    private boolean processMethodWithSupers(Class aClass, Method method, Processor<Method> processor) {
        if (method != null && !processor.process((Object)method)) {
            return false;
        }
        Class superClass = aClass.getSuperclass();
        if (superClass != null ? !this.processMethods(superClass, processor) : aClass.isInterface() && !this.processMethods(Object.class, processor)) {
            return false;
        }
        for (Class<?> anInterface : aClass.getInterfaces()) {
            if (this.processMethods(anInterface, processor)) continue;
            return false;
        }
        return true;
    }

    public final List<Method> getAllMethods(Class startFrom) {
        ArrayList<Method> result = new ArrayList<Method>();
        this.processMethods(startFrom, Processors.cancelableCollectProcessor(result));
        return result;
    }

    @Nullable
    public final <T extends Annotation> Method findAnnotatedMethod(final Class<T> annotationClass, final Class startFrom) {
        CommonProcessors.FindFirstProcessor<Method> processor = new CommonProcessors.FindFirstProcessor<Method>(){

            protected boolean accept(Method method) {
                Object annotation = method.getAnnotation(annotationClass);
                return annotation != null && ReflectionUtil.isAssignable(method.getDeclaringClass(), (Class)startFrom);
            }
        };
        this.processMethods(startFrom, (Processor<Method>)processor);
        return (Method)processor.getFoundValue();
    }

    @Nullable
    public final <T extends Annotation> T findAnnotation(final Class<T> annotationClass, Class startFrom) {
        CommonProcessors.FindFirstProcessor<Method> processor = new CommonProcessors.FindFirstProcessor<Method>(){

            protected boolean accept(Method method) {
                Object annotation = method.getAnnotation(annotationClass);
                return annotation != null;
            }
        };
        this.processMethods(startFrom, (Processor<Method>)processor);
        Method foundMethod = (Method)processor.getFoundValue();
        return foundMethod == null ? null : (T)foundMethod.getAnnotation(annotationClass);
    }

    public String toString() {
        return this.myMethodName + Arrays.asList(this.myMethodParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodSignature that = (JavaMethodSignature)o;
        if (!this.myMethodName.equals(that.myMethodName)) {
            return false;
        }
        return Arrays.equals(this.myMethodParameters, that.myMethodParameters);
    }

    public int hashCode() {
        int result = this.myMethodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.myMethodParameters);
        return result;
    }
}

